module ROMdecoder_stand2(
input logic clk,
input logic[23:0] ROMdata_0,
input logic[23:0] ROMdata_1,
input logic[23:0] ROMdata_2,
input logic[23:0] ROMdata_3,
input logic[23:0] ROMdata_4,
input logic[23:0] ROMdata_5,
input logic[23:0] ROMdata_6,
input logic[10:0] hcount,
input logic[9:0] vcount,
input logic[15:0] hexv, hexh,

output logic[7:0] Routput,
output logic[7:0] Goutput,
output logic[7:0] Boutput,
output logic[10:0] addr
);


logic[10:0] addr_h;
logic[23:0] ROMdata_sel;
assign addr_h = hexv[15]?
					43-(hcount/2-(hexh[9:0]-21)):
					hcount/2-(hexh[9:0]-21);

assign ROMdata_sel = (hexv[14:12]==3'b000)?
							ROMdata_0:
							(hexv[14:12]==3'b001)?
							ROMdata_1:
							(hexv[14:12]==3'b010)?
							ROMdata_2:
							(hexv[14:12]==3'b011)?
							ROMdata_3:
							(hexv[14:12]==3'b100)?
							ROMdata_4:
							(hexv[14:12]==3'b101)?
							ROMdata_5:
							(hexv[14:12]==3'b110)?
							ROMdata_6:
							ROMdata_0;
										
assign addr = (vcount-(hexv[9:0]-21))*44 + addr_h;
assign Boutput = ROMdata_sel[7:0];
assign Goutput = ROMdata_sel[15:8];
assign Routput = ROMdata_sel[23:16];

endmodule
//every second read from the ROM 24bit data and parse it into 3 R G B data
//output to the VGA