module ROMdecoder_pointer(
input logic clk,
input logic[23:0] ROMdata,
input logic[10:0] hcount,
input logic[9:0] vcount,
input logic[15:0]  hex2, hex3, hex4, hex5, hex6,

output logic[7:0] Routput,
output logic[7:0] Goutput,
output logic[7:0] Boutput,
output logic[18:0] addr
);

logic[6:0]  hexh, hexv;
logic[15:0] hexv_stand, hexh_stand, differ_h, differ_v;

assign hexv = hex6[5:0]+ 6;
assign hexh = hex6[11:6] + 6;
assign hexv_stand = hex6[13]? // 1: stand_2, 0: stand_1;
							hex4,
							hex2;

assign hexh_stand = hex6[13]?
							hex5,
							hex3;
							
assign differ_v = hex6[12]?  // 0: down, 1: up;
						(hexv_stand-hexv):
						(hexv_stand+hexv);
						
assign differ_h = hexv_stand[15]? //0:face to right, 1:face to left 
						(hexh_stand-hexh):
						(hexh_stand+hexh);
					
assign addr=(vcount-differ_v)*13+(hcount/2-differ_h);
assign Boutput=ROMdata[7:0];
assign Goutput=ROMdata[15:8];
assign Routput=ROMdata[23:16];

endmodule

