module ROMdecoder_explosion(
input logic clk,
input logic [23:0] ROMdata_1,
input logic [23:0] ROMdata_2,
input logic [23:0] ROMdata_3,
input logic [23:0] ROMdata_4,
input logic [23:0] ROMdata_5,
input logic [23:0] ROMdata_6,
input logic [23:0] ROMdata_7,
input logic [23:0] ROMdata_8,
input logic [23:0] ROMdata_9,

input logic [10:0] hcount,
input logic [9:0] vcount,
input logic [15:0] hexh,hexv,

output logic [7:0] Routput,
output logic [7:0] Goutput,
output logic [7:0] Boutput,
output logic [11:0] addr
);

logic [23:0]ROMdata_sel; 

assign ROMdata_sel = (hexh[15:12] == 4'd1)? ROMdata_1:
					    	(hexh[15:12] == 4'd2)? ROMdata_2:
							(hexh[15:12] == 4'd3)? ROMdata_3:
							(hexh[15:12] == 4'd4)? ROMdata_4:
							(hexh[15:12] == 4'd5)? ROMdata_5:
							(hexh[15:12] == 4'd6)? ROMdata_6:
							(hexh[15:12] == 4'd7)? ROMdata_7:
							(hexh[15:12] == 4'd8)? ROMdata_8:
							(hexh[15:12] == 4'd9)? ROMdata_9:24'd0;             
							
assign addr = (vcount-(hexv[9:0]-31))*64+hcount/2-(hexh[9:0]-31);//middle
assign Boutput = ROMdata_sel[7:0];
assign Goutput = ROMdata_sel[15:8];
assign Rouptut = ROMdata_sel[23:16];

endmodule

