module ROMdecoder3(
input logic clk,
input logic[23:0] ROMdata_G,
input logic[23:0] ROMdata_M,
input logic[23:0] ROMdata_T,
input logic[10:0] hcount,
input logic[9:0] vcount,
input logic[15:0] hexv, hexh,

output logic[7:0] Routput,
output logic[7:0] Goutput,
output logic[7:0] Boutput,
output logic[18:0] addr
);


logic[23:0] ROMdata_sel;
//initial ROMdata_sel = ROMdata_M;
assign ROMdata_sel = (hexh[11:10]==2'b01)?
							ROMdata_G:
							(hexh[11:10]==2'b10)?
							ROMdata_M:
							(hexh[11:10]==2'b11)?
							ROMdata_T:
							24'd0;
							
assign addr=(vcount-65)*15+(hcount/2-20);
assign Boutput = ROMdata_sel[7:0];
assign Goutput = ROMdata_sel[15:8];
assign Routput = ROMdata_sel[23:16];


endmodule
//every second read from the ROM 24bit data and parse it into 3 R G B data
//output to the VGA