module ROMdecoder2(
input logic clk,
input logic[23:0] ROMdata_G,
input logic[23:0] ROMdata_M,
input logic[23:0] ROMdata_T,
input logic[10:0] hcount,
input logic[9:0] vcount,
input logic[15:0] hexv, hexh,

output logic[7:0] Routput,
output logic[7:0] Goutput,
output logic[7:0] Boutput,
output logic[18:0] addr
);


logic[23:0] ROMdata_sel;
assign ROMdata_sel = (hexh[11:10]==3'b01)?
							ROMdata_G:
							(hexh[11:10]==3'b10)?
							ROMdata_M:
							(hexh[11:10]==3'b11)?
							ROMdata_T:
							24'b0;
							
assign addr=(vcount-(hexv[9:0]-7))*15+(hcount/2-(hexh[9:0]-7));
assign Boutput = ROMdata_sel[7:0];
assign Goutput = ROMdata_sel[15:8];
assign Routput = ROMdata_sel[23:16];


endmodule
//every second read from the ROM 24bit data and parse it into 3 R G B data
//output to the VGA