#include <stdio.h>
#include <stdlib.h> 
#include <math.h>
#include "global.h"
#include "Tank_map.h"

/*   The standard of the transmission message of Tank              */
// use 32 bit message to transmit the tank info.: 0~9: y position; 10~20: x position; 21~24: Tank Type; 25~27: Tank Direction; 28: TankFlag  31~29: Reserved
// This file defines the tank's generation, direction and moving modules.

///////////////////////////////////////////////////////tank_module_begin//////////////////////////////////////////////

void generate_one_tank(unsigned int x, unsigned int y,unsigned int direction, unsigned int tank_num)
{	
	if(explosion_flag[tank_num]==no_explosion)
	   tank_type[tank_num]=tank_final_state[tank_num];

        else if(explosion_flag[tank_num]==Generate2)
            {	   tank_type[tank_num]=Generate2;
                 if (generate_delay==0){
                   explosion_flag[tank_num]=no_explosion;
                   generate_delay=Generate_Delay;}
                 else if (generate_delay!=0)
                   generate_delay--;   
            }
        else if( explosion_flag[tank_num]==Generate1)	
	    {   
		tank_flag[tank_num]=Tank_exist;
		tank_x[tank_num]=x;
		tank_y[tank_num]=y;
		tank_x_temp[tank_num]=x;
		tank_y_temp[tank_num]=y;
		tank_direction[tank_num]=direction;

                if(tank_num!=0 && tank_num!=1)
		tank_direction_buffer[tank_num]=direction;
 		tank_type[tank_num]=Generate1;
		
		if (generate_delay==0){
                 explosion_flag[tank_num]=Generate2;
                 generate_delay=Generate_Delay;}
               else if (generate_delay!=0)
                 generate_delay--;  
	    }

}//This is the tank generation function unit. Later it'll be called to generate each single tank. 








void generate_config(unsigned int tank_num)
{        
	unsigned int random = rand()%100;
         if(tank_own_remaining > 0 )
              {
                  if(tank_num==0 )
	          generate_one_tank(320,416,up,tank_num);

  		  else if (tank_num==1){
                  tank_direction_buffer[tank_num]=0;
		  generate_one_tank(640,416,up,tank_num);
		 }
	      }		
		         
 	 if((tank_enemy_remaining>0) && (tank_num !=Player1_Tank) &&(tank_num !=Player2_Tank))
	      {
	         if(random<33){
		 generate_one_tank(64,32,down,tank_num);
	        }	 
		
		 else if(random<66){
	         generate_one_tank(512,32,down,tank_num);
		}	
	         
		  else if (random<100){
	         generate_one_tank(1024,32,down,tank_num); }
	      }		
	
}//This function defines the 5 birth places,1 for each player, 3 for enemy. Tanks will be generated in a place accoding to their number.  







void tank_generate(unsigned int tank_num)
{          if(tank_type[tank_num]==notank){
               tank_flag[tank_num]=Tank_miss;
               return;}
	   if((tank_num<OWNTANK && tank_own_remaining > 0 )||(OWNTANK<=tank_num && tank_num<MAXTANK                   &&tank_enemy_remaining>4 ) )
             {
                      if(explosion_flag[tank_num]==no_explosion)
		       generate_one_tank(tank_x[tank_num],tank_y[tank_num],tank_direction[tank_num],tank_num);

		      else if(explosion_flag[tank_num]==Generate2){
		       generate_one_tank(tank_x[tank_num],tank_y[tank_num],tank_direction[tank_num],tank_num);
		   
			}
                      else if(explosion_flag[tank_num]==Generate1) { 
		              if( generate_delay==Generate_Delay)
			         generate_config(tank_num);
			      else 
			         generate_one_tank(tank_x[tank_num],tank_y[tank_num],tank_direction[tank_num],tank_num); 
			}
	     }
      
}// Generation process was separeted into 3 phases. Each phase has its own graph shown.   
 // Genarate1, Genarate2 and no_explosion are flags indicating each phase.


void player_tank_direction( unsigned int tank_num )
{            
		switch(tank_direction_buffer[tank_num])
		{
	 	    case up:    tank_direction[tank_num]=Tank_up; break;
  				
  			        
                    case down:  tank_direction[tank_num]=Tank_down;break;
  				 
  			         
		    case left:  tank_direction[tank_num]=Tank_left;break;
  				 
  			       
                    case right: tank_direction[tank_num]=Tank_right;break;

  			        
                    case stop:  tank_direction[tank_num]= tank_direction[tank_num];  break;
				  
                }
}
  

void move_attempt(unsigned int tank_num)
{
    switch(tank_direction_buffer[tank_num])
        {   case up:    {
		      	 tank_x_temp[tank_num]=tank_x_temp[tank_num];
	              	 tank_y_temp[tank_num]=tank_y_temp[tank_num]-step;
	             	 break;	
		        }
            case down:  {
		         tank_x_temp[tank_num]=tank_x_temp[tank_num];
			 tank_y_temp[tank_num]=tank_y_temp[tank_num]+step;
	                 break;
			}
            case left:  {
			tank_x_temp[tank_num]=tank_x_temp[tank_num]-2*step;
		        tank_y_temp[tank_num]=tank_y_temp[tank_num];
	                break;
			}
            case right: {
			 tank_x_temp[tank_num]=tank_x_temp[tank_num]+2*step;
		 	 tank_y_temp[tank_num]=tank_y_temp[tank_num];
 			 break;
			}
            case stop:  {
			 tank_direction[tank_num]= tank_direction[tank_num];
		         tank_x_temp[tank_num]=tank_x_temp[tank_num];
		         tank_y_temp[tank_num]=tank_y_temp[tank_num];
			 break;
			}  
	}
}

            
void enemy_tank_direction(unsigned int tank_num)
	{   			       
				        int random = rand()%100;
					if(random<25)
					{
					tank_direction[tank_num]=Tank_up;
					tank_direction_buffer[tank_num]=up;
					}

					else if(random<50)
					{
					tank_direction[tank_num]=Tank_down;	
					tank_direction_buffer[tank_num]=down;
					}
					else if(random<75)
					{
					tank_direction[tank_num]=Tank_left;
					tank_direction_buffer[tank_num]=left;
					}
					else 
					{
					tank_direction[tank_num]=Tank_right;
					tank_direction_buffer[tank_num]=right;
					}
				
	}   
 // This function is used for setting the tank's direction mainly including 2 parts: player part and enemy part. 
 // Player tank's direction information comes from the game controller corresponding to the 'case' part in the program.
 // The enemy keeps its direction if there is no obstacle in front. Otherwise the enemy will chooses a direction based on a random value.

void tank_move(unsigned int tank_num)
{  			
			
			if(tank_num!=0 && tank_num!=1 && tank_stop_flag[tank_num]==1)
			enemy_tank_direction(tank_num);
                        
			if(tank_stop_flag[tank_num] && explosion_flag[tank_num]==no_explosion)
			{ 	
 			tank_x_temp[tank_num]=tank_x[tank_num];
			tank_y_temp[tank_num]=tank_y[tank_num];

			}
			else if (explosion_flag[tank_num]==no_explosion)
			{   	
			tank_x[tank_num]=tank_x_temp[tank_num];
			tank_y[tank_num]=tank_y_temp[tank_num];
			}	
	
}// This function defines the moving rules of the tank. If there's no obstacle in front, tanks move as the designated direction. Otherwise, the tanks will stop.

void tank(unsigned int tank_num )
{ 
 if(explosion_flag[tank_num]==Generate1 ||explosion_flag[tank_num]==Generate2||explosion_flag[tank_num]==no_explosion)
 tank_generate(tank_num);

 if(tank_num<OWNTANK)
 player_tank_direction(tank_num);

 move_attempt(tank_num);

 generate_flag(tank_num);

 tank_move(tank_num);

 
 ///form tank message sent to hardware///
 message_tank[tank_num]= (tank_flag[tank_num]<<28) + (tank_direction[tank_num]<<25) + (tank_type[tank_num]<<21)+(tank_x[tank_num]<<10)+tank_y[tank_num];

 
}// tank module: including tank's generation, set direction and move functions putting them all together.


