/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

int vga_led_fd;

/* Read and print the segment values */
void print_segment_info() {
  vga_led_arg_t vla;
  int i;

  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    if (ioctl(vga_led_fd, VGA_LED_READ_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_READ_DIGIT) failed");
      return;
    }
    printf("%02x ", vla.segments);
  }
  printf("\n");
}

/* Write the contents of the array to the display */
void write_segments(const unsigned char segs[8])
{
  vga_led_arg_t vla;
  int i;
  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    vla.segments = segs[i];
    if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
      return;
    }
  }
}

int main()
{
  vga_led_arg_t vla;
  int i;
  int xdir, ydir;
  xdir=1;
  ydir=1;
  int xcount, ycount;
  static const char filename[] = "/dev/vga_led";

  static unsigned char message[8] = { 0x03, 0x20, 0x00, 0xEA,     //initialize x=800 and y=250
				      0x66, 0x7F, 0x66, 0x3F };

  printf("VGA LED Userspace program started\n");

  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  printf("initial state: ");
  print_segment_info();



  printf("current state: ");
  print_segment_info();
  ///////////////////////////////////////////bouncing ball//////////////////////

for(;;){
 if ((message[0]==0x00 & message[1]==0x50)||(message[0]==0x04 & message[1]==0xB0))
      {xdir=-xdir;
          } 

 if ((message[2]==0x00 & message[3]==0x28)||(message[2]==0x01 & message[3]==0xb8))
      {ydir=-ydir;
          } 
   message[1]=message[1]+xdir*1;
   message[3]=message[3]+ydir*1;
   if (message[1]==0x00 & xdir==1)
      {
       message[0]=message[0]+1;
       message[1]=0x00;
        }
   if (message[1]==0xFF & xdir==-1)
      {
       message[0]=message[0]-1;
       message[1]=0xFF;
        }
   if (message[3]==0x00 & ydir==1)
      {
       message[2]=message[2]+1;
       message[3]=0x00;
        }
   if (message[3]==0xFF & ydir==-1)
      {
       message[2]=message[2]-1;
       message[3]=0xFF;
        }


   
   
  
  write_segments(message);
    usleep(5000);
   

}

   
     

 

  /*for (i = 0 ; i < 24 ; i++) {
    unsigned char c0 = message[0];
    memmove(message, message+1, VGA_LED_DIGITS - 1);
    message[VGA_LED_DIGITS - 1] = c0;
    write_segments(message);
    usleep(400000);
  }*/
  
  printf("VGA LED Userspace program terminating\n");
  return 0;
}
