/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */
#include <stdlib.h>
#include <stdio.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include "global.h"
#include "joystick.h"
#include "writemessage.h"
#include "gamecontroller.h"
#include "bullet_map.h"
#include "tank_bullet.h"
#include "explosion.h"
#include "initial.h"
#include "iowrite.h"
#include "tank.h"
#include "initial_tank_generation.h"
#include "Tank_map.h"

int main()
{
// initial keyboard end
 
  int clear_key = 1;
  vga_led_arg_t vla;
  static const char filename[] = "/dev/vga_led";

if ( (joystick = openjoystick(&endpoint_address)) == NULL ) {
   		fprintf(stderr, "Did not find a joystick\n");
    		exit(1);
  	}

//initial position of every object and its flag,
 
  

  printf("VGA axis Userspace program started\n");

  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  printf("initial state: ");
  print_segment_info();




  printf("current state: ");
  print_segment_info();
  


// initial keyboard end
  
    while (start==welcome){             // wait for begin game
   gamecontroller();
       
         }

  // begin game //////////////////////////////////////////////////////////////////////////////////////////
  initial_game();
  unsigned int k;
  unsigned int initial_tank_i;

     while(initial_tanks==1)
{ 
  for (initial_tank_i=0;initial_tank_i<5;initial_tank_i++){
     generate_initial_tanks(initial_tank_i);
      iowrite();}
   
 if(tank_type[4]==2)
  initial_tanks=0;
  
}



//control the movement of every object  
  while(start==begin_game) {
  

     gamecontroller();  // Furture need to put it in another thread
    unsigned int tank_num_i;

    for (tank_num_i=0;tank_num_i<OWNTANK;tank_num_i++){   // generate for own tank
        initial_loop();

       
       tank(tank_num_i);
         

      // bullet module
      bullet_module(bullet_buffer[tank_num_i], tank_num_i);
     }       


    for (tank_num_i=OWNTANK;tank_num_i<MAXTANK;tank_num_i++){   // generate for enemy tank
          initial_loop();


       tank(tank_num_i);
      
      // bullet module
        unsigned int random_bullet = rand()%100;                     //random for enemy tank 
         if (random_bullet==0)
             bullet_buffer[tank_num_i]=shoot;
         else if (random_bullet!=0)
             bullet_buffer[tank_num_i]=0;



      bullet_module(bullet_buffer[tank_num_i], tank_num_i);
     
          }

      // module for explosion 
          unsigned int tank_explosion_i;
         for (tank_explosion_i=0;tank_explosion_i<7;tank_explosion_i++){
            tank_explosion(tank_explosion_i);}
       

       //command_message update
       if (tank_enemy_remaining==0 )
         { start=gameover_win; }
       else if (tank_own_remaining==0)
         { start=gameover_lose;}



       command_message =  (start<<30)  + ((tank_enemy_remaining)<<20) + ((tank_own_remaining)<<17); 

        iowrite();// transmit message


   }
////////////////////////////////////////////////////////////

  // game over /////////////////////////////////////////////////////////////////////
   while (1) {
       command_message =  (start<<30)  + ((tank_enemy_remaining)<<20) + ((tank_own_remaining)<<17); 
         iowrite();// transmit message     
     
    }
  
    
  // end of program


 
  
  printf("VGA LED Userspace program terminating\n");
  return 0;
}

