#ifndef GLOBAL_H_
#define GLOBAL_H_

#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include "joystick.h"

/* Game Parameter */
#define TOTAL_TANK    22
#define MAXTANK 7
#define OWNTANK 2
#define ENEMYTANK 5
#define MAXBULLET MAXTANK
#define Numsubrick 70                //NOTE: TEMPERAL RESERVED
#define REMAINING_ENEMY_TANK 5
#define REMAINING_OWN_TANK 4
#define Generate_Delay 20
unsigned int generate_delay=Generate_Delay;



/*   The standard of the transmission message of Tank              */
// use 32 bit message to transmit the tank: 0~9: y position; 20~10: x position; 21~24: Tank Type; 25~27: Tank Direction; 28: TankFlag  31~29: Reserved
unsigned int message_tank[MAXTANK];
//Tank type
#define Player1_Tank  0
#define Player2_Tank  1
#define Enemy_Tank    2
#define Generate1     3
#define Generate2     4
#define Explosion1    5
#define Explosion2    6
#define no_explosion  7 // hardware no need to consider
#define notank  8

//Tank Direction
#define Tank_up 1
#define Tank_down 2
#define Tank_left  3
#define Tank_right 4
#define Tank_static 5   // means tank has no action, may not be used
#define step       1
// Tank Flag
#define Tank_exist 1
#define Tank_miss  0

/*   The standard of the transmission message of Bullet             */
// use 32 bit message to transmit the bullet: 0~9: y position; 20~10: x position; 21: TankFlag 31~22 Reserved
//Use the 31 bit of third message to transmit the homebase flag
unsigned int message_bullet[MAXBULLET];
// Bullet Flag
#define Bullet_exist 1
#define Bullet_miss  0


/*   The standard of the transmission message of subbrick             */
// use 32 bit message to transmit the subbullet_flag. now, we need to transmit 69 of subbrick, use 3 messages
unsigned int message_subbrick[3];
// Subbrick Flag
#define brick_exist 1
#define brick_miss  0
// address of 46, the MSB presents Homebase
#define Homebase_exist 1
#define Homebase_miss  0

/* The standard of the transmission message of command instructions */
unsigned int command_message;  // transmit this message at the address of 127
//Use 31~30bits: transmit command instrus;  29~20bits: The remaining No. of enemy;  19~17bits: The remaining No. of owntank
#define welcome 0
#define begin_game 1
#define gameover_win 2
#define gameover_lose 3


// gamecontroller module
struct libusb_device_handle *joystick;
uint8_t endpoint_address;

int vga_led_fd;


static unsigned int message[4]={0x0000,0x0000,0x0000};
int transferred;
struct usb_joystick_packet packet;

// joystick define                                       // we should define this by ourselves
#define stop  0  
#define up    1  
#define down  2 
#define left  3
#define right 4
#define shoot 5
#define start_game 6
#define pause 7

unsigned int start=welcome;  // if start=0, means the game has not begin; 1:represent begin game; 2:means game over
unsigned int start_flag=1; //used for stay in the game



//bullet module//
#define bullet_up 1
#define bullet_down 2
#define bullet_left 3
#define bullet_right 4
#define bullet_static 5

unsigned int bullet_flag[MAXBULLET]; // 0~1 represent own bullet, 2~6: enemy bullet
unsigned int bullet_x[MAXBULLET];
unsigned int bullet_y[MAXBULLET];
unsigned int bullet_buffer[MAXBULLET]={0,0,0,0,0,0,0}; // in order to store the button from joystick or random for shoot
unsigned int bullet_direction[MAXBULLET];

//tank module//
unsigned int tank_flag[MAXTANK]={0,0,0,0,0,0,0}; // 0~1 represent own tank, 2~6: enemy tank
unsigned int tank_x[MAXTANK]={320,640,64,512,1024,64,1024}; 
unsigned int tank_y[MAXTANK]={416,416,32,32,32,32,32};
unsigned int tank_x_temp[MAXTANK]={320,640,64,512,1024,64,1024}; 
unsigned int tank_y_temp[MAXTANK]={416,416,32,32,32,32,32};
unsigned int tank_direction_buffer[MAXTANK]={0,0,2,2,2,2,2};//in order to store the direction info. from joystick or random #
unsigned int tank_direction[MAXTANK]={0,0,2,2,2,2,2};
 int tank_enemy_remaining=REMAINING_ENEMY_TANK;
 int tank_own_remaining=REMAINING_OWN_TANK;
unsigned int tank_final_state[MAXTANK]={Player1_Tank,Player2_Tank,Enemy_Tank,Enemy_Tank,Enemy_Tank,Enemy_Tank,Enemy_Tank}; 
unsigned int tank_type[MAXTANK]={Generate1,Generate1,Generate1,Generate1,Generate1,Generate1,Generate1} ;
unsigned int generate_timer=0;     
  // 0 represents player1; 1 represents player2; 3-6 represents enemy;  //define the Player type
 
/*Map parameter  */

#define Numsubbrick 70

//Tank_map module
   //Sprite type
#define Brick 1
#define Steel 2
#define Grass 3
#define Water 4
#define Homebase 5
#define Sprite_Player1 6
#define Sprite_Player2 7
//#define Enemy 8
#define Greybackground 8

//Tank Move Flag
unsigned int tank_stop_flag[MAXTANK];           //flag for tank move or not 1 means stop
unsigned int Generating_Place_Occupied[MAXTANK]={0,0,0,0,0,0,0};//flag for generating places: 1 means these places are occupied


//bullet map
#define sub_birck_hit 1
#define sub_birck_pass  0
#define sub_tank_hit 1
#define sub_tank_pass  0
#define sub_bullet_hit 1
#define sub_bullet_pass  0
unsigned int bullet_map_homebase;
unsigned int bullet_map_steel;
unsigned int bullet_map_grey_background;
unsigned int bullet_map_tank;
unsigned int bullet_map_tank_sub[MAXTANK];
unsigned int bullet_map_brick;
unsigned int bullet_map_brick_sub[Numsubbrick];
unsigned int bullet_map_bullet;
unsigned int bullet_map_bullet_sub[MAXBULLET];
unsigned int sub_brick_flag[Numsubbrick];

//explosion module

unsigned int explosion_flag[MAXTANK]={Generate1,Generate1,Generate1,Generate1,Generate1,Generate1,Generate1};   // need to initial the value to Generate1

//IO Write
#define iodelay 1000
#define maxmessage  128
#define maxtankmessage 22
#define maxbulletmessage maxtankmessage
#define maxsubbrick 3   //temporal reserved; need to change to transmit map
unsigned int iomessage [maxmessage];
unsigned int initial_tanks=1;


#endif




