# A Tcl script for the Qsys system console

# Start Qsys, open your soc_system.qsys file, run File->System Console,
# then execute this script by selecting it with Ctrl-E

# The System Console is described in Chapter 10 of Volume III of
# the Quartus II Handbook

# Alternately,
# system-console --project_dir=. --script=syscon-test.tcl
#
# system-console --project_dir=. -cli
#   and then "source syscon-test.tcl"

# Base addresses of the peripherals: take from Qsys
set toe_init 0x0

puts "Started system-console-test-script"

# Using the JTAG chain, check the clock and reset"

set j [lindex [get_service_paths jtag_debug] 0]
open_service jtag_debug $j
puts "Opened jtag_debug"

puts "Checking the JTAG chain loopback: [jtag_debug_loop $j {1 2 3 4 5 6}]"
jtag_debug_reset_system $j

puts -nonewline "Sampling the clock: "
foreach i {1 1 1 1 1 1 1 1 1 1 1 1} {
    puts -nonewline [jtag_debug_sample_clock $j]
}
puts ""

puts "Checking reset state: [jtag_debug_sample_reset $j]"

close_service jtag_debug $j
puts "Closed jtag_debug"

# Perform bus reads and writes

set m [lindex [get_service_paths master] 0]
open_service master $m
puts "Opened master"

puts "Request connection #1"
# Write a test pattern to the various registers
foreach {r v} {4 0x00000000 8 0x00000000 12 0x11111111 16 0x22222222 20 0x33333333 24 0x33330000 28 0x44444444 32 0x44440000 36 0x55550000 40 0x66660000 0 0x40000000}  {
    master_write_32 $m [expr $toe_init + $r] $v
}
puts "Waiting for the request to be processed" 
# Wait until the connection has been added to the RAM
puts "Reply #1 : [master_read_32 $m [expr $toe_init + 8] 0x1]"
puts "Request has been processed successfully"
master_write_32 $m $toe_init 0x0
puts "Request deasserted"

puts "Request connection #2"
# Write a test pattern to the various registers
foreach {r v} {4 0x00000000 8 0x00000000 12 0xffffffff 16 0xffffffff 20 0xffffffff 24 0xffff0000 28 0xffffffff 32 0xffff0000 36 0xffff0000 40 0xffff0000 0 0x40000000}  {
    master_write_32 $m [expr $toe_init + $r] $v
}
puts "Waiting for the request to be processed" 
# Wait until the connection has been added to the RAM
puts "Reply #2 : [master_read_32 $m [expr $toe_init + 8] 0x1]"
puts "Request has been processed successfully"
master_write_32 $m $toe_init 0x0
puts "Request deasserted"

puts "Request connection #1 again" 
# Write a test pattern to the various registers
foreach {r v} {4 0x00000000 8 0x00000000 12 0x11111111 16 0x22222222 20 0x33333333 24 0x33330000 28 0x44444444 32 0x44440000 36 0x55550000 40 0x66660000 0 0x40000000}  {
    master_write_32 $m [expr $toe_init + $r] $v
}
puts "Waiting for the request to be processed" 
# Wait until the connection has been added to the RAM
puts "Reply #3 : [master_read_32 $m [expr $toe_init + 8] 0x1]"
puts "Request has failed ERR_FOUND" 
master_write_32 $m $toe_init 0x0
puts "Request deasserted"

puts "Requesti deletion of connection #2" 
# Write a test pattern to the various registers
foreach {r v} {4 0x73000000 8 0x00000000 12 0x00000000 16 0x00000000 20 0x00000000 24 0x00000000 28 0x00000000 32 0x00000000 36 0x00000000 40 0x00000000 0 0x80000000}  {
    master_write_32 $m [expr $toe_init + $r] $v
}
puts "Waiting for the request to be processed" 
# Wait until the connection has been added to the RAM
puts "Reply #4 : [master_read_32 $m [expr $toe_init + 8] 0x1]"
puts "Request succeeded" 
master_write_32 $m $toe_init 0x0
puts "Request deasserted"

puts "Request connection #2 again"
# Write a test pattern to the various registers
foreach {r v} {4 0x00000000 8 0x00000000 12 0xffffffff 16 0xffffffff 20 0xffffffff 24 0xffff0000 28 0xffffffff 32 0xffff0000 36 0xffff0000 40 0xffff0000 0 0x40000000}  {
    master_write_32 $m [expr $toe_init + $r] $v
}
puts "Waiting for the request to be processed" 
# Wait until the connection has been added to the RAM
puts "Reply #2 : [master_read_32 $m [expr $toe_init + 8] 0x1]"
puts "Request has been processed successfully"
master_write_32 $m $toe_init 0x0
puts "Request deasserted"


close_service master $m
puts "Closed master"




