library verilog;
use verilog.vl_types.all;
entity RAM_searcher is
    generic(
        LAST_RECORD     : vl_logic_vector(0 to 7) := (Hi1, Hi1, Hi1, Hi1, Hi0, Hi0, Hi0, Hi0);
        TCP_CLOSED      : vl_logic_vector(0 to 30) := (Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi1);
        REQ_CONN        : vl_logic_vector(0 to 1) := (Hi0, Hi1);
        REQ_DEL         : vl_logic_vector(0 to 1) := (Hi1, Hi0);
        ERR_FOUND       : vl_logic_vector(0 to 7) := (Hi1, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0);
        ERR_FULL        : vl_logic_vector(0 to 7) := (Hi1, Hi1, Hi0, Hi0, Hi0, Hi0, Hi0, Hi0)
    );
    port(
        clk             : in     vl_logic;
        rst             : in     vl_logic;
        req             : in     vl_logic_vector(1 downto 0);
        reply           : out    vl_logic_vector(7 downto 0);
        id_in           : in     vl_logic_vector(7 downto 0);
        ip_src          : in     vl_logic_vector(31 downto 0);
        ip_dst          : in     vl_logic_vector(31 downto 0);
        mac_src         : in     vl_logic_vector(47 downto 0);
        mac_dst         : in     vl_logic_vector(47 downto 0);
        port_src        : in     vl_logic_vector(15 downto 0);
        port_dst        : in     vl_logic_vector(15 downto 0);
        addr            : out    vl_logic_vector(7 downto 0);
        data            : out    vl_logic_vector(31 downto 0);
        q               : in     vl_logic_vector(31 downto 0);
        wren            : out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of LAST_RECORD : constant is 1;
    attribute mti_svvh_generic_type of TCP_CLOSED : constant is 1;
    attribute mti_svvh_generic_type of REQ_CONN : constant is 1;
    attribute mti_svvh_generic_type of REQ_DEL : constant is 1;
    attribute mti_svvh_generic_type of ERR_FOUND : constant is 1;
    attribute mti_svvh_generic_type of ERR_FULL : constant is 1;
end RAM_searcher;
