/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

int vga_ball_fd;

/* Read and print the segment values */
void print_directions_info() {
  vga_ball_arg_t vla;
  int i;

  for (i = 0 ; i < 2 ; i++) {
    vla.axis = i;
    if (ioctl(vga_ball_fd, VGA_BALL_READ_AXIS, &vla)) {
      perror("ioctl(VGA_BALL_READ_AXIS) failed");
      return;
    }
    printf("%02x ", vla.direction);
  }
  printf("\n");
}

/* Write the contents of the array to the display */
void write_directions(const unsigned int directions[2])
{
  vga_ball_arg_t vla;
  int i;
  for (i = 0 ; i < 2 ; i++) {
    vla.axis = i;
    vla.direction = directions[i];
    if (ioctl(vga_ball_fd, VGA_BALL_WRITE_AXIS, &vla)) {
      perror("ioctl(VGA_BALL_WRITE_AXIS) failed");
      return;
    }
  }
}

int main()
{
  vga_ball_arg_t vla;
  int i;
  int left=0,up=0;
  static const char filename[] = "/dev/vga_ball";

  static unsigned int message[2]={320,0};

  printf("VGA BALL Userspace program started\n");

  if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  printf("initial state: ");
  print_directions_info();

  write_directions(message);

  printf("current state: ");
  print_directions_info();
  
  int count1=0;
  for (;;) {
    write_directions(message);
    usleep(4000); 
    if (left == 0) {
        message[0]++;
    } 
    if (left == 1) {
        message[0]--;
    }
    if (message[0] == 590) {
         left = 1;
    }
    if (message[0] == 50) {
         left = 0;
    }   
    if (up == 0) {
        message[1]++;
    }
    if (up == 1) {
        message[1]=message[1]-1;
    }
    if (message[1] == 430) {
       up = 1;
    }
    if (message[1] == 50) {
       up = 0;
    }
    
        
  }
  
  printf("VGA LED Userspace program terminating\n");
  return 0;
}
