`timescale 1ns/1ns

module tb_movement(output logic testout);

logic clk;
logic reset;
logic [15:0] x_ship;
logic [15:0] y_ship;
//reg [15:0] x_b;
//reg [15:0] y_b;
logic [31:0] game_logic_to_movement;
logic movement_ready;

logic [31:0] movement_to_game_logic;
logic movement_done;

movement movement_and_tb(.clk(clk), .reset(reset), .x_ship(x_ship), .y_ship(y_ship), .game_logic_to_movement(game_logic_to_movement), .movement_ready(movement_ready), .movement_to_game_logic(movement_to_game_logic), .movement_done(movement_done));

initial
begin
clk = 0;
reset = 0;
movement_ready = 0;
 x_ship = 16'd320;
 y_ship = 16'd240;
game_logic_to_movement = 32'b0000_0001_0101000000_0011110000_00_00;//ship info
// 
end

initial
begin
@(posedge clk);
reset =1;
@(posedge clk);
reset =0;
#20;
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

//test bullet
 #80   game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_01_00;//bullet_left_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

#80   game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_01_01;//bullet_leftup_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

#80  	 game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_01_10;//bullet_leftup_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

#80    game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_00_10;//bullet_leftup_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

#80    game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_10_00;//bullet_leftup_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

#80    game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_10_01;//bullet_leftup_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

#80    game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_10_10;//bullet_leftup_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

 #80 	 game_logic_to_movement = 32'b0000_0010_0101000000_0011110000_00_01;//bullet_leftup_info
#20
@(posedge clk);
movement_ready = 1;
@(posedge clk);
movement_ready = 0;

testout = movement_done;
end
always #10 clk = ~clk;

endmodule
