`timescale 1ns/1ns
module tb_game_logic_movement(output logic testout);
logic clk;
logic reset;
logic [15:0] writedata;
logic [2:0] address;
 logic    write;
logic chipselect;
logic draw_done;
/*
    output logic [7:0] VGA_R, VGA_G, VGA_B,
    output logic       VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
    output logic       VGA_SYNC_n);*/
logic [31:0] movement_to_game_logic;
logic movement_done;

game_logic_movement dut(.*);

always #10 clk = ~clk;

initial begin
    clk = 1'd0;
    reset = 1'd0;
    writedata = 16'd0;
    address = 3'd0;
    draw_done = 0;
end

initial begin
    
    @(posedge clk);
    reset = 1;
    @(posedge clk);
    reset = 0;
    write = 1;
    chipselect = 1;
 
    
    //#20;
    //@(posedge clk);
    address = 3'd0;
    writedata = 16'd320;
    @(posedge clk);
    address = 3'd1;
    writedata = 16'd240;
    @(posedge clk);
    address = 3'd2;
    writedata = 16'd1;
    @(posedge clk);
    address = 3'd3;
    writedata = 16'd2;
    
    #360;
    @(posedge clk);
    draw_done = 1;
    @(posedge clk);
    draw_done = 0;
    
    //the new data
    address = 3'd0;
    writedata = 16'd480;
    @(posedge clk);
    address = 3'd1;
    writedata = 16'd120;
    @(posedge clk);
    address = 3'd2;
    writedata = 16'd3;
    @(posedge clk);
    address = 3'd3;
    writedata = 16'd0;
    

    testout = movement_done;
end

endmodule

