`timescale 1ps/1ps

module tb_game_logic;

reg clk;
reg reset;
reg [31:0] movement_to_game_logic;
reg movement_done;
reg draw_done;
reg [15:0] x;
reg [15:0] y;
reg [15:0] x_b;
reg [15:0] y_b;
 
wire [7:0] addr;
wire we;
wire update_done;
wire [31:0] game_logic_to_movement;
wire movement_ready;

movement movement_and_tb(.clk(clk), .reset(reset), .movement_to_game_logic(movement_to_game_logic), .movement_done(movement_done), .draw_done(draw_done), .x(x), .y(y), .x_b(x_b), .y_b(y_b), .addr(addr), .we(we), update_done(update
_done), .game_logic_to_movement(game_logic_to_movement), .movement_ready(movement_ready);

initial
begin
clk = 0;
reset = 1;

#50 reset = 0;
#25 validreg = 1;
    readypreproc = 1;
    startofpacket = 1;
    mesg = 8'h39;
#25 startofpacket = 0;
#25 mesg = 8'h3D;
#50 mesg = 8'h37;






end

always #25 clk = ~clk;

endmodule
