
//
// Additional Comments:
// Module takes the form of a linear congruential generator, which should be
// sufficient for our purposes. Basically, this is a linear function,
// X(n+1) = A*X(n) + C, but then the high order bits are truncated, so
// we take mod n, which is assumed here to be a power of 2 for simplicity.
// Version 1.0
//
/////////////////////////////////////////////////////////////////////////////
///
module random_number_generator
(   input logic reset,
	input logic clock,
	input logic [31:0] seed,
	output logic [31:0] random);
parameter A = 22695477;
parameter C = 1;
logic[31:0] random_reg;
always @(posedge clock) begin
	if (reset)
		random_reg <= seed;
	else
		random_reg <= A*random_reg + C; //Overflow intended
	end
assign random = random_reg;
endmodule