`timescale 1ns/1ns
module myram_tb ();
    logic clk;
    logic we;
    logic show_all;
    logic [31:0] data_in;
    logic [31:0] data_out;
    logic [7:0] address;
    logic [31:0] data_0;

    myram dut(.*);

    always #10 clk = ~clk;

    initial begin
        clk = 1'd0;
        we = 1'd0;
        show_all = 1'd0;

        @(posedge clk);
            data_in = 32'd1;
            we = 1'd1;
            address = 1'd0;
        @(posedge clk);
            we = 1'd0;
        #40;
        @(posedge clk);
            data_in = 32'd2;
            we = 1'd1;
            address = 1'd1;
         @(posedge clk);
            we = 1'd0;
    end
endmodule


