module movement (
    input logic clk,    // Clock
    input logic reset, // Clock Enable
    input logic [15:0] x_ship,  // ship x
    input logic [15:0] y_ship, //ship y
    //input logic [15:0] x_b,//bullet x
    //input logic [15:0] y_b, //bullet y
    input logic [31:0] game_logic_to_movement,//data from game logic
    input logic movement_ready,//movement module is ready to go
    output logic [31:0] movement_to_game_logic,
    output logic movement_done);

    parameter NO_ID = 8'd0;
    parameter SHIP = 8'd1;
    parameter BULLET = 8'd2;
	 parameter SPAWN = 8'd3;
	 parameter ENEMY4 = 8'd4;
	 parameter ENEMY5 = 8'd5;
	 parameter ENEMY6 = 8'd6;
	 parameter ENEMY7 = 8'd7;
	 parameter EXPLOSION_BULLET = 8'd11;
	 parameter EXPLOSION_SPACESHIP = 8'd12;
	 
    logic [7:0] id; //ID of entity
    logic [9:0] x_value;// X aixs
    logic [9:0] y_value;// Y aixs
    logic [1:0] x_d_value; //direction X aixs
    logic [1:0] y_d_value; //direction Y aixs

    // use this to store the information of game_logic_to_move when movement_ready = 1.
    //By doing so, the value in current entry will not changed by the value from game logic
    //when movement_ready =0
    logic [31:0] current_entry;
	 integer enemy5_xdir, enemy5_ydir, enemy4_xdir, enemy4_ydir;   //, enemy6_counter;
	 
    assign id = current_entry[31:24];
    assign x_value = current_entry[23:14];
    assign y_value = current_entry[13:4];
    assign x_d_value = current_entry[3:2];
    assign y_d_value = current_entry[1:0];

    logic [7:0] new_id; //New ID of entity
    logic [9:0] new_x_value;// New X aixs
    logic [9:0] new_y_value;// New Y aixs
    logic [1:0] new_x_d_value; // New Bullet X aixs
    logic [1:0] new_y_d_value; // New Bullet Y aixs
	 
	 logic [6:0] spawn_counter1,spawn_counter2,spawn_counter3,spawn_counter4, enemy4_counter, enemy5_counter, enemy6_counter;
	  logic [6:0] explosion_bullet_counter1,explosion_bullet_counter2,explosion_bullet_counter3,explosion_bullet_counter4;
	  logic [6:0] explosion_spaceship_counter1,explosion_spaceship_counter2,explosion_spaceship_counter3,explosion_spaceship_counter4;

    assign movement_to_game_logic = {new_id,new_x_value,new_y_value,new_x_d_value,new_y_d_value};

    enum logic [2:0] {IDLE, PROCESSING, DONE} states;

    always @(posedge clk) begin
        if(reset) begin

            movement_done <= 0;
            current_entry <=32'd0;
            states <= IDLE;

            new_id <=NO_ID; //New ID of entity
            new_x_value <=10'd0;// New X aixs
            new_y_value <=10'd0;// New Y aixs
            new_x_d_value <=10'd0; // New Bullet X aixs
            new_y_d_value <=10'd0;
				//added counter for spinning---JS&XX
				explosion_bullet_counter1 <= 7'd0;
				explosion_bullet_counter2 <= 7'd0;
				explosion_bullet_counter3 <= 7'd0;
				explosion_bullet_counter4 <= 7'd0;
				spawn_counter1 <= 7'd0;
				spawn_counter2 <= 7'd0;
				spawn_counter3 <= 7'd0;
				spawn_counter4 <= 7'd0;
				//enemy4_counter <= 7'd0;
				enemy5_counter <= 7'd0;
				enemy6_counter <= 7'd0;
				explosion_spaceship_counter1 <= 7'd0;
				explosion_spaceship_counter2 <= 7'd0;
				explosion_spaceship_counter3 <= 7'd0;
				explosion_spaceship_counter4 <= 7'd0;
				enemy5_xdir <= 1;
				enemy5_ydir <= 1;
				enemy4_xdir <= 2;
				enemy4_ydir <= 2;
        end
        else begin
            if(states == IDLE) begin
                if(movement_ready) begin //if ready, start to process
                    states <= PROCESSING;
                    current_entry[31:0] <= game_logic_to_movement[31:0]; //protect value
                end
                movement_done <=0;
            end
            else if(states == PROCESSING) begin
                if(id == SHIP) begin
                    new_id <= SHIP;
                    new_x_value <= x_ship[9:0];
                    new_y_value <= y_ship[9:0];
                    new_x_d_value <= x_d_value;
                    new_y_d_value <= y_d_value;
						  movement_done <= 0;
                    states <= DONE;
                end
                if(id == BULLET) begin
							  if(x_value > 10'd600 | y_value > 10'd440 | x_value < 0 | y_value < 0) begin
									new_id <= NO_ID;
							  end
							  //left
							  else if(x_d_value == 2'b00 & y_d_value == 2'b00) begin
									new_id <= BULLET;
									new_x_value <= x_value - 10'd4;
									new_y_value <= y_value;
									new_x_d_value <= x_d_value;
									new_y_d_value <= y_d_value;


							  end
							  //leftup
							  else if(x_d_value == 2'b01 & y_d_value == 2'b01) begin
								  new_id <= BULLET;
									new_x_value <= x_value - 10'd4;
									new_y_value <= y_value - 10'd4;
									new_x_d_value <= x_d_value;
									new_y_d_value <= y_d_value;

							  end
							  //leftdown
							  else if(x_d_value == 2'b01 & y_d_value == 2'b10) begin
									new_id <= BULLET;
									new_x_value <= x_value - 10'd4;
									new_y_value <= y_value + 10'd4;
									new_x_d_value <= x_d_value;
									new_y_d_value <= y_d_value;

							  end
							  //down
							  else if(x_d_value == 2'b00 & y_d_value == 2'b10) begin
									new_id <= BULLET;
									new_x_value <= x_value;
									new_y_value <= y_value + 10'd4;
									new_x_d_value <= x_d_value;
									new_y_d_value <= y_d_value;

							  end
							  //right
							  else if(x_d_value == 2'b10 & y_d_value == 2'b00) begin
									new_id <= BULLET;
									new_x_value <= x_value + 10'd4;
									new_y_value <= y_value;
									new_x_d_value <= x_d_value;
									new_y_d_value <= y_d_value;

							  end
							  //rightdown
							  else if(x_d_value == 2'b10 & y_d_value == 2'b10) begin
									new_id <= BULLET;
									new_x_value <= x_value + 10'd4;
									new_y_value <= y_value + 10'd4;
									new_x_d_value <= x_d_value;
									new_y_d_value <= y_d_value;

							  end
							  //rightup
							  else if(x_d_value == 2'b10 & y_d_value == 2'b01) begin
									new_id <= BULLET;
									new_x_value <= x_value + 10'd4;
									new_y_value <= y_value - 10'd4;
									new_x_d_value <= x_d_value;
									new_y_d_value <= y_d_value;
							  end
							  //up
							  else if(x_d_value == 2'b00 & y_d_value == 2'b01) begin
                        new_id <= BULLET;
                        new_x_value <= x_value;
                        new_y_value <= y_value-10'd4;
                        new_x_d_value <= x_d_value;
                        new_y_d_value <= y_d_value;

                    end
						  states <= DONE;
                    movement_done <=0; //FFFF
                end
					 
						else if (id == SPAWN) begin
							if(x_value > 10'd600 | y_value > 10'd440 | x_value < 0 | y_value < 0) begin
                        new_id <= NO_ID;
                    end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00 & spawn_counter1 == 7'd15)begin
								new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b01;
								spawn_counter1 <= 0; 
						  end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00 & spawn_counter1 != 7'd15)begin
								new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
								spawn_counter1 <= spawn_counter1 + 1; 
						  end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b01 & spawn_counter2 == 7'd15)begin
								new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b01;
								new_y_d_value <= 2'b01;
								spawn_counter2 <= 0; 
						  end
							else if (x_d_value == 2'b00 & y_d_value == 2'b01 & spawn_counter2 != 7'd15)begin
								new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b01;
								spawn_counter2 <= spawn_counter2 + 1; 
						  end
						  else if (x_d_value == 2'b01 & y_d_value == 2'b01& spawn_counter3 == 7'd15)begin
								new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b01;
								new_y_d_value <= 2'b00;
								spawn_counter3 <= 0; 
						  end
						  else if (x_d_value == 2'b01 & y_d_value == 2'b01& spawn_counter3 != 7'd15)begin
								new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b01;
								new_y_d_value <= 2'b01;
								spawn_counter3 <= spawn_counter3 + 1; 
						  end
						  else if (x_d_value == 2'b01 & y_d_value == 2'b00& spawn_counter4 == 7'd15)begin
								//new_id <= ENEMY4;
								//new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
								spawn_counter4 <= 0; 
								case(x_value%3)
									0: new_id<=ENEMY4;
									1: new_id<=ENEMY5;
									2: new_id<=ENEMY6;
									//3: new_id<=ENEMY7;
								default: new_id<=ENEMY6;
								endcase
						  end
						  else if (x_d_value == 2'b01 & y_d_value == 2'b00& spawn_counter4 != 7'd15)begin
								//new_id <= ENEMY4;
								new_id <= SPAWN;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b01;
								new_y_d_value <= 2'b00;
							spawn_counter4 <= spawn_counter4 + 1; 
						  end
							states <= DONE;
							movement_done <= 0;	
					 end
									 //SPAWN TURN INTO ENEMY4, bouncing ---bluecirle
					 else if (id == ENEMY4) begin
						  if(x_value > 10'd600 | y_value > 10'd440 | x_value < 0 | y_value < 0) begin
                        new_id <= NO_ID;
                    end
						  else begin
							new_id <= ENEMY4;
								new_x_value <= x_value - 1;
								new_y_value <= y_value + 1;
							end
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
								states <= DONE;
								movement_done <= 0;	
					 end
					 
					 //SPAWN TURN INTO ENEMY5, curve --- redcircle
					 else if (id == ENEMY5) begin
						  if(x_value > 10'd600 | y_value > 10'd440 | x_value < 0 | y_value < 0) begin
                        new_id <= NO_ID;
                    end
						  else begin
								new_id <= ENEMY5;
								new_x_value <= x_value + 1;
								new_y_value <= y_value + 1;
							end
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
								states <= DONE;
								movement_done <= 0;	
					 end
					 
					 //SPAWN  TURN  INTO ENEMY6, chase after the spaceship --triangle
					 
					 else if (id == ENEMY6) begin
							if(x_value > 10'd600 | y_value > 10'd440 | x_value < 0 | y_value < 0) begin
                        new_id <= NO_ID;
                    end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00)begin
								new_id <= ENEMY6;								
								if(x_ship[9:0]>= x_value) begin
									new_x_value <= x_value + 1;
								end
								else begin
									new_x_value <= x_value - 1;
								end
								if(y_ship[9:0]>= y_value) begin
									new_y_value <= y_value + 1;
								end
								else begin
									new_y_value <= y_value - 1;
								end
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
						  end
							states <= DONE;
							movement_done <= 0;	
					 end
					 
					 //SPAWN  TURN  INTO ENEMY7, circle around the spaceship----rectangular
					 
					 else if (id == ENEMY7) begin
							if(x_value > 10'd600 | y_value > 10'd440 | x_value < 0 | y_value < 0) begin
                        new_id <= NO_ID;
                    end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00)begin
								new_id <= ENEMY7;								
								if(x_ship[9:0]>= x_value) begin
									new_x_value <= x_value + 1;
								end
								else begin
									new_x_value <= x_value - 1;
								end
								if(y_ship[9:0]>= y_value) begin
									new_y_value <= y_value + 1;
								end
								else begin
									new_y_value <= y_value - 1;
								end
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
						  end
							states <= DONE;
							movement_done <= 0;	
					 end
					 
					////////////////////////////explosion_bullet/////////////////ffffff
					 
					 else if (id == EXPLOSION_BULLET) begin
							if(x_value > 10'd640 | y_value > 10'd480 | x_value < 0 | y_value < 0) begin
                        new_id <= NO_ID;
                    end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00 & explosion_bullet_counter1 == 7'd10)begin
								new_id <= EXPLOSION_BULLET;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b01;
								explosion_bullet_counter1 <= 0; 
						  end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00 & explosion_bullet_counter1 != 7'd10)begin
								new_id <= EXPLOSION_BULLET;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
								explosion_bullet_counter1 <= explosion_bullet_counter1 + 1; 
						  end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b01 & explosion_bullet_counter2 == 7'd10)begin
								new_id <= NO_ID;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b01;
								new_y_d_value <= 2'b01;
								explosion_bullet_counter2 <= 0; 
						  end
							else if (x_d_value == 2'b00 & y_d_value == 2'b01 & explosion_bullet_counter2 != 7'd10)begin
								new_id <= EXPLOSION_BULLET;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b01;
								explosion_bullet_counter2 <= explosion_bullet_counter2 + 1; 
						  end
	
							states <= DONE;
							movement_done <= 0;	
					 end
					 
/*
///////////////////////////////////////////////////////////////////////////////////	ffffff		 
////////////////////////////////explosion_spaceship////////////////////////////////////
					 else if (id == EXPLOSION_SPACESHIP) begin
							if(x_value > 10'd600 | y_value > 10'd440 | x_value < 0 | y_value < 0) begin
                        new_id <= NO_ID;
                    end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00 & explosion_spaceship_counter1 == 7'd10)begin
								new_id <= EXPLOSION_SPACESHIP;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b01;
								explosion_spaceship_counter1 <= 0; 
						  end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b00 & explosion_spaceship_counter1 != 7'd10)begin
								new_id <= EXPLOSION_SPACESHIP;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
								explosion_spaceship_counter1 <= explosion_spaceship_counter1 + 1; 
						  end
						  else if (x_d_value == 2'b00 & y_d_value == 2'b01 & explosion_spaceship_counter2 == 7'd10)begin
								new_id <= NO_ID;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b00;
								explosion_spaceship_counter2 <= 0; 
						  end
							else if (x_d_value == 2'b00 & y_d_value == 2'b01 & explosion_spaceship_counter2 != 7'd10)begin
								new_id <= EXPLOSION_SPACESHIP;
								new_x_value <= x_value;
								new_y_value <= y_value;
								new_x_d_value <= 2'b00;
								new_y_d_value <= 2'b01;
								explosion_spaceship_counter2 <= explosion_spaceship_counter2 + 1; 
						  end
	
							states <= DONE;
							movement_done <= 0;	
					 end
/////////////////////////////////explosion_spaceship/////////////////////////////////	*/				 
					 else if (id  == NO_ID) begin
							new_id <= 8'd0;
                     new_x_value <=  10'd0;
                     new_y_value <= 10'd0;
                     new_x_d_value <= 4'd0;
                     new_y_d_value <= 4'd0;
							states <= DONE;
							movement_done <= 0;
					 end
                else begin
					    // new_id <= 8'd0;
                    //new_x_value <=  10'd0;
                    //new_y_value <= 10'd0;
                    //new_x_d_value <= 4'd0;
                    //new_y_d_value <= 4'd0;
                    states <= DONE;
                    movement_done <= 0; //ffff
                end
            end
            else if(states == DONE) begin
                movement_done <= 1;
                states <= IDLE;
            end
        end
    end
endmodule
