module game_logic (
    input logic clk,    // Clock
    input logic reset,
    input logic [31:0] movement_to_game_logic,  // output data from movement module
    input logic movement_done, //movement module finishes its work
    input logic draw_done, //Vga_Emulator finishes its work
    input logic [15:0] x, //ship x
    input logic [15:0] y, //ship y
    input logic [15:0] x_b,//bullet x
    input logic [15:0] y_b,//bullet y
    //input logic [31:0] mem_out, //output of myram
	//output logic [31:0] mem_in, //input of myram
    //output logic [7:0] C_addr, //address for the RAM C to choose data
    //output logic C_we, //write enable for the RAM C
    output logic update_done, //Tell Vga_Emulator to start drawing
    output logic [31:0] game_logic_to_movement,//data needed to be passed to movement module
    output logic [31:0] game_logic_to_emulator,//data needed to be passed to vga_emulator
    output logic emulator_receive_en,//enable vga_emulator to receive information
    output logic ram_select,//tell vga_emulator to select which
    output logic movement_ready, //tell movement module to start its work
	 
	 output logic [31:0] to_collision_entry, //entity info data sent to collision module
    input logic from_collision_received, from_collision_done, //signal from collision module 
    output logic to_collision_ready,//signal to collision indicating ready for sending entity 
    output logic [15:0] score, //record the score of the game 
	 output logic avatar_initial
);

    logic movement_ready_delay;
    logic [3:0] bullet_cycle_counter;
    logic [31:0] A_mem_out;
    logic [31:0] B_mem_out;
    logic [31:0] C_mem_out;
    logic [31:0] mem_in;
    logic B_we;//wrtie enable for the RAM B
    logic A_we;//write enable for the RAM A
    logic C_we;//write enable for the RAM C
    logic game_cycle_toggle; //choose which ram we should use
    //when ram_select = 0, ram A is used to draw and Ram B is used to store updated information
    assign ram_select = game_cycle_toggle;
    logic [7:0] A_addr;
    logic [7:0] B_addr;
    logic [7:0] C_addr;
	 
	  ///////////////////////spawn///////////////////////////////////
	 logic spawn_wait_pause;
     logic [31:0] random;
    //State Definition
    random_number_generator randomnumber (.clock(clk), .seed(0), .reset(reset), .random(random));
	 ///////////////////////spawn///////////////////////////////////
	 
    //logic [7:0] addr_for_data_to_emulator;//addr used for passing data to emulator
    //if game_cycle_toggle = 1, Ram A is used to store the updated information
    assign A_addr = game_cycle_toggle ? C_addr : 0;
    //if game_cycle_toggle = 0, Ram B is used to store the updated information
    assign B_addr = game_cycle_toggle ? 0 : C_addr;
    assign A_we = game_cycle_toggle ? C_we : 0;
    assign B_we = game_cycle_toggle ? 0 : C_we;
    //if game_cycle_toggle = 1, Ram A is passed to emulator
    assign game_logic_to_emulator = game_cycle_toggle ? A_mem_out : B_mem_out;
    assign game_logic_to_movement = C_mem_out;
	 
	 	 //-------Added logic for collision ------JS
     logic [7:0] working_index; //track primary in collision 
     logic [1:0] lives;
     logic game_over;
     assign to_collision_entry = C_mem_out; 
	 //----------------collision logic-------------
	 
	 
    myram ram_A(.clk(clk),.we(A_we),.data_in(mem_in),.data_out(A_mem_out),.address(A_addr));
    myram ram_B(.clk(clk),.we(B_we),.data_in(mem_in),.data_out(B_mem_out),.address(B_addr));
    myram ram_C(.clk(clk),.we(C_we),.data_in(mem_in),.data_out(C_mem_out),.address(C_addr));

	logic [2:0] wait_cycle_count;
	logic bullet_wait_pause;
	logic bullet_decide;
	logic [1:0] spawn_wait_counter;
	logic [9:0] x_random;
	logic [9:0] y_random;
	assign x_random = {1'd0, random[24:16]};
	assign y_random = {1'd0, random[14:6]};
	
	logic avatar_die;//ff
	
    //State Definition
    enum logic [14:0] {precollision,collision,collision_processing,avatar_collided,done,reset_state,
	 spawn_wait, premoving,moving,bullet,to_emulator,emulator_wait,decide_spawn,spawning, game_over_states} states;
	 enum logic [12:0] {cs_wait_address,cs_idle, cs_wait_working, cs_receive_working, cs_receive_collided, cs_destroy_working,cs_destroy_collided_wait,
	 cs_destroy_collided, cs_swap, cs_cleanup, cs_finish,cs_destroy_bullet_pre,cs_destroy_bullet} sub_states;
	 
    always_ff @(posedge clk) begin
        if(reset) begin
            mem_in <= 0;
            C_we <= 0;
            game_cycle_toggle <= 0;   //Ram A is used to draw, Ram B is used to store
            emulator_receive_en <= 0; //disable emulator to receive information
            C_addr <= 8'b0000_0000;
            update_done <= 1; //let emulator draw the background
            movement_ready <= 0;
            states <= reset_state;
            bullet_cycle_counter <= 4'd0;
            //show_all <= 0; //test
			wait_cycle_count <= 3'd0;
			bullet_wait_pause <= 1'd0;
			bullet_decide <= 1'd0;
			spawn_wait_pause <= 1'd0;
			lives <= 2'd3;
			score <= 16'd0;
			working_index <= 8'd0;  //xx
			game_over <= 0; //xx		
			
			
        end

        else begin
            if (states == reset_state) begin
                states <= decide_spawn;//next cycle goes to decide_spawn states
					 sub_states <= cs_idle;
					 avatar_initial <= 1;
                update_done <= 0;
					 avatar_die <= 0;
					 working_index <= 8'd0;
					 bullet_cycle_counter <= 4'd0;
                //addr <= addr + 8'd1; //next cycle address = 0, store the ship information
                mem_in <= {8'b0000_0001,10'd320,10'd240,x_b[1:0],y_b[1:0]}; //next cycle, the ship information is the input to myram
                C_we <= 1; //next cycle, enable write for myram !!!!!!!!!!!!!  we = 1 next cycle !!!!!!!!!!!!!!!!
            end
				
				else if (states == decide_spawn) begin
					 update_done <= 0;
               
                if (random[31:28] != 4'b0_000) begin
                    states <= bullet;
                    C_we <= 0; //disable the write enable for myram
                end
                else begin states <= spawning;
                     C_we <= 0;
							C_addr <= 8'd15;    //////eeeeedit address
                end
            end
            else if (states == spawning) begin
                if (C_addr == 8'd30) begin //end of enermy, should generate non-enermy instead
                    C_addr <= 8'd15;             //////eeeeedit address
                    C_we <= 0;
                    states <= premoving; // if all occupied, go back to decide state to check if need to generate new enermy
                end
                else if (spawn_wait_pause) begin
                    states <= spawning;
                    spawn_wait_pause <= 1'd0;
                end
                else if (C_mem_out[31:24] == 8'd0 & !spawn_wait_pause) begin
						  if(!(x_random >= x[9:0]-10'd32 && x_random <= x[9:0]+10'd64 && y_random <= y[9:0]-10'd32 && y_random >= y[9:0] + 10'd64))begin
							  mem_in <= {8'd3, x_random, y_random, 4'd0}; //generate 1 enermy with direction of 0

							 C_we <= 1;
							  //states <= bullet;
							  states <= spawn_wait;
							  spawn_wait_pause <= 1'd0;
					  end
						  
                end
                else begin
                    C_addr <= C_addr + 8'd1;
                    spawn_wait_pause <= 1'd1;
                end
            end	
				else if (states == spawn_wait) begin
					if (spawn_wait_counter == 2'd2) begin
						states <= bullet;
						spawn_wait_counter <= 2'd0;
					end
					else begin
						spawn_wait_counter <= spawn_wait_counter+2'd1;
					end
				end

            else if(states == bullet) begin
                //update_done <= 0;
                if(bullet_cycle_counter != 4'd10/*for test only*/) begin //should we generate new bullet? yes for this case
                    states <= premoving;
                    C_we <= 0;//next cycle, disable write for myram
                end
                else begin //do not generate bullet
						if(C_addr >= 8'd15 ) begin //test only bound 12 //reach the bound 128 for bullet
                            C_addr <= 8'd1; //re-search the addr from 0 //////eeeeedit address
                            C_we <= 0;
                            states <= premoving;
                    end
						else if (bullet_decide) begin
							if (wait_cycle_count == 3'd0) begin
								states <= bullet;//what if all the address is occupied ?
								wait_cycle_count <= 3'd0;
								bullet_wait_pause <= 1'd0;
								bullet_decide <= 1'd0;
							end
						end
                    else if (C_mem_out[31:24] == 8'b0000_0000 & !bullet_wait_pause) begin //at current addr, no thing in the myram
						      if (x_b[1:0] == 2'b00 & y_b[1:0] == 2'b00) begin //left 
									mem_in <={8'b0000_0010,x[9:0]-10'd16,y[9:0],x_b[1:0],y_b[1:0]};//intialize data about bullets
                        end
								else if (x_b[1:0] == 2'b01 & y_b[1:0] == 2'b01) begin //leftup
									mem_in <={8'b0000_0010,x[9:0]-10'd16,y[9:0]-10'd16,x_b[1:0],y_b[1:0]};//intialize data about bullets
								end
								else if (x_b[1:0] == 2'b01 & y_b[1:0] == 2'b10) begin //leftdown
									mem_in <={8'b0000_0010,x[9:0]-10'd16,y[9:0]+10'd16,x_b[1:0],y_b[1:0]};//intialize data about bullets
								end
								else if (x_b[1:0] == 2'b00 & y_b[1:0] == 2'b10) begin //down
									mem_in <={8'b0000_0010,x[9:0],y[9:0]+10'd16,x_b[1:0],y_b[1:0]};//intialize data about bullets
								end
								else if (x_b[1:0] == 2'b10 & y_b[1:0] == 2'b00) begin //right
									mem_in <={8'b0000_0010,x[9:0]+10'd16,y[9:0],x_b[1:0],y_b[1:0]};//intialize data about bullets
								end
								else if (x_b[1:0] == 2'b10 & y_b[1:0] == 2'b10) begin //rightdown
									mem_in <={8'b0000_0010,x[9:0]+10'd16,y[9:0]+10'd16,x_b[1:0],y_b[1:0]};//intialize data about bullets
								end
								else if (x_b[1:0] == 2'b10 & y_b[1:0] == 2'b01) begin //rightup
									mem_in <={8'b0000_0010,x[9:0]+10'd16,y[9:0]-10'd16,x_b[1:0],y_b[1:0]};//intialize data about bullets
								end
								else if (x_b[1:0] == 2'b00 & y_b[1:0] == 2'b01) begin //up
									mem_in <={8'b0000_0010,x[9:0],y[9:0]-10'd16,x_b[1:0],y_b[1:0]};//intialize data about bullets
								end
								C_we <= 1; //next cycle, enable myram to be written
                        states <= premoving;
                        bullet_cycle_counter <= 4'd0; //reset counter, once generated
						bullet_wait_pause <= 1'd0;
                    end
                    else begin //at current addr, something occupied, try next addr
                        C_addr <= C_addr + 8'd1; //increase addr
						bullet_decide <= 1;
						bullet_wait_pause <= 1'd1;
                        //we <= 0; //next cycle disable myram to be written
                    end
                end
            end
            else if(states == premoving) begin
                states <= moving; //next cycle goes to moving states
                movement_ready_delay <= 1; //next next cycle, movement can updata (look at last line in moving state)
                C_we <= 0; //next cycle, the value in the myram cannot be changed
                C_addr <= 8'd0;
            end
            else if(states == moving) begin
                if(movement_done) begin  //if movement module finishes its jobs
                    avatar_initial <= 0;
						  mem_in <= movement_to_game_logic; //take data from movemnet module and update its value in next cycle
                    C_we <= 1; //next cycle, enable movement module
                    movement_ready_delay <= 0; //next cycle, make movement could not process data from mem_out
                        //if(addr == 8'd255) begin //every item in myram has been updated
                        if (C_addr == 8'd30) begin //for test only //////eeeeedit address
                            //update_done <= 1;
							//show_all <= 1;
                            states <= precollision;
                            C_addr <= 8'b1111_1111;//prepare for pass the value to emulator
                        end
                end
                else if(C_we) begin //if last cycle, we = 1, it means that, at this cycle, data at addr will be updated. then we should updata the value in addr+1 next
                    C_addr <= C_addr+1; //update address
                    movement_ready_delay <= 1; //next cycle, movement module could update value at addr+1
                    C_we <= 0; //next cycle, myram could not be changed
                end
                else begin
                    movement_ready_delay <= 0; //if not above cases, means movement moudle is processing the data it recieved last time, disable it to process new data
                end
                movement_ready <= movement_ready_delay;//if movement_ready_delay is 1 (0) at this cycle, then next cycle movement_ready will be 1 (0).
            end
				
				else if (states == precollision) begin
					C_we <= 0;
					if(C_addr == 0) begin //starting from the first primary 
                  states <= collision;    //goes into collision state
                  to_collision_ready <= 1;//ready to send data to collision module
                  working_index <= 8'd0;//checking from the first entity as the first primary
                  C_addr <= 8'd15;//secondary units start from 128----?//////eeeeedit address
               end
					else begin
						C_addr <= 0;
					end
				end
				
				else if (states == collision) begin
					if(to_collision_ready==1) begin
                   to_collision_ready <= 0 ;//reset the ready signal to 0 until the collision module is done checking with all the enemies
                   C_addr <= 8'd15; // reset the secondary entity to start from 128//////eeeeedit address
                   //flg <= 1;
               end
					if(working_index == 8'd14) begin //done with checking all the non-enemy entities
						 C_addr <= 8'd255;
                   states <= to_emulator; //done with collision checking state and now goes to emulator
               end
					else if (from_collision_received)begin
						if(C_addr < 8'd15) begin //c_addr changes from 0--9(non-enermy)to see if there's collision   //////eeeeedit address
														//in the loop inside, each non-enermy check if there's collision to enermy from 10--20
							C_addr <= 8'd15;//reset the secondary back to 128
                     to_collision_ready <= 1;//set ready signal to 1 to send the next primary entity
                  end
                  else if (C_addr == 8'd30) begin   ////////////////////////////////255?////////////////////////
                            working_index <= working_index + 8'd1;//if done with checking all the 128 secondary entities move on to the next primary entity
                            C_addr <= working_index + 8'd1; //send the data of the next primary to collision module
                  end
						else begin
                  C_addr <= C_addr + 8'd1; //if not done with the 128 enemies, move to the next secondary
						end
					end
					else if (from_collision_done==1)begin
                        states <= collision_processing;//when done with the collision module
								C_addr <= working_index;// getting data of the current primary entity
                        sub_states <= cs_wait_address;//move to the collision processing state
                        working_index <= C_addr-8'd1; //store current enermy address
               end		
				end	
				else if (states == collision_processing) begin 			
					if (sub_states == cs_wait_address) begin
						sub_states <= cs_destroy_working;
					end
					else if (sub_states == cs_destroy_working)begin
						if (C_mem_out[31:24] == 8'd0 ) begin  //C_addr stores non_enermy,if it is no_id, there would be no hit
							sub_states <= cs_swap;
						end
						else begin
							C_addr <= working_index; //after the change. C_addr stores enermy when working_index stores non-enermy
							working_index <= C_addr;
							sub_states <= cs_destroy_collided_wait;
						end
					end
					else if (sub_states == cs_destroy_collided_wait)begin
						sub_states <= cs_destroy_collided;
					end
					else if (sub_states == cs_swap)begin
							//C_we <= 0;
							C_addr <= working_index; //C_addr stores enermy and working index stores the nonenermy
							working_index <= C_addr;
							sub_states <= cs_cleanup;
					end
					else if (sub_states == cs_destroy_collided)begin
					//first check if non_enermy is the spaceship
						if (working_index == 8'd0)begin
							if(C_mem_out[31:24]!= 8'd3)begin  //the spaceship didn't hit the spawn, then it lose a life
								lives <= lives - 2'd1;
								//mem_in <= 32'b0;
								//C_we <= 1; 
								C_addr <= 8'd255;
								if(lives==2'd0) begin
									game_over <= 1;
									states <= done; 
									C_addr <= 0;
								end
								else begin
                         states <= avatar_collided;
								 sub_states <= cs_idle;
								end
								end
							else begin
								sub_states <= cs_cleanup;	// spaceship hit the spawn, go to check the next non-enermy
							end
							end
					//there is a collision between bullet and enermy
						else begin 
							if(C_mem_out[31:24]== 8'd11||C_mem_out[31:24]==8'd3) begin  // take no action on explosion and spawn, C_addr stores the address of enermy
								sub_states <= cs_cleanup;	
								C_we <=0;
							end
							else begin	mem_in <= {8'd11, C_mem_out[23:4], 4'h0}; // explosion for bullet: id = 11 write the explosion into current enermy address ffff
								C_we <= 1;
								score <= score +1; 
								//sub_states <= cs_destroy_bullet;
								sub_states <= cs_cleanup;
							end
						end
					end

					else if (sub_states == cs_cleanup) begin
							C_we <= 0;
                     working_index <= working_index +8'd1; 
							C_addr <= working_index + 8'd1;
                     sub_states <= cs_finish;
               end 
               else if (sub_states == cs_finish) begin
                    to_collision_ready <= 1; 
                    states <= collision;
						  sub_states <= cs_idle; 
                    
               end 
						
				end
			
				//collision_processing state 
				else if (states == avatar_collided) begin
                     if(C_addr==8'd30)begin
                        states <= to_emulator; 
                        C_we <= 0; 
								avatar_die <= 1;
                     end
                     else begin
                        C_addr <= C_addr +1; // the spaceship was hit by an enermy 
                        mem_in <=32'd0; // all objects on the screen turn to be explosions
                        C_we <= 1; 
								avatar_die <= 0;
                     end 
            end 
					 
            else if(states == to_emulator) begin
                C_we <= 0;
                emulator_receive_en <= 1; //next cycle, emulator starts to recvice value from selected ram
                C_addr <= C_addr + 1;
                states <= emulator_wait;
            end
            else if(states == emulator_wait) begin
                states <= to_emulator;
                if(C_addr == 8'd30) begin     
                    states <= done;
                    emulator_receive_en <= 0;
                end
            end
            else if(states == done) begin
                states <= done;
                C_we <= 0;
           
					if(draw_done == 1) begin //vga_emulator finishes its job, it's time to update
						if (avatar_die == 1) begin
							states <= reset_state;
							C_addr <= 8'd0;
						end
						else begin 
							states <= decide_spawn; //at this state make update_done = 0!!!!!!!
							C_addr <= 8'd1;
						end
						update_done <= 1;
						game_cycle_toggle <=  ~game_cycle_toggle;
						bullet_cycle_counter <= bullet_cycle_counter + 4'd1; //when draw_done, increase bullet_cycle_counter, until it reaches 8. (see bullet states)
					
				end
			end
        end
    end
endmodule