module collision(
    	input logic clock,reset,
	input logic [31:0] game_logic_to_collision,  //entry 
	input logic to_collision_ready,  //from game logic 
	output logic to_game_logic_received,  
        output logic to_game_logic_done);

	logic [31:0] non_enemy_entry, enemy_entry;
	logic signed [9:0] x_diff, y_diff;  //difference btw non_enemy_x/y and enemy_x/y
	logic [23:0] x_diff_sq, y_diff_sq;
	logic [12:0] non_enemy_r_sq, enemy_r_sq;

	logic [7:0] non_enemy_id, enemy_id; //ID of entity
	logic [9:0] non_enemy_x, enemy_x;// X axis
	logic [9:0] non_enemy_y, enemy_y;// Y axis
	//logic [1:0] non_enemy_x_d, enemy_x_d; //direction X axis
	//logic [1:0] non_enemy_y_d, enemy_y_d; //direction Y axis

	parameter NO_ID = 8'd0;
	parameter SHIP = 8'd1;
	parameter BULLET = 8'd2;
	parameter E1 = 8'd3;
	//parameter E2 = 8'd4;
	//parameter E3 = 8'd5;

        //State Definition
        enum logic [7:0] {WAIT_RECEIVE,IDLE, RECEIVE, PROCESS, WAIT, DIFF, SQUARE, COMPARE} states;

	assign non_enemy_id = non_enemy_entry[31:24];
	assign non_enemy_x = non_enemy_entry[23:14];
	assign non_enemy_y = non_enemy_entry[13:4];
	//assign non_enemy_x_d = non_enemy_entry[3:2];
	//assign non_enemy_y_d = non_enemy_entry[1:0];
	assign enemy_id = enemy_entry[31:24];
	assign enemy_x = enemy_entry[23:14];
	assign enemy_y = enemy_entry[13:4];
	//assign enemy_x_d = enemy_entry[3:2];
	//assign enemy_y_d = enemy_entry[1:0];

	always @(posedge clock) begin
	    if (reset) begin
		non_enemy_entry <= 0;
		enemy_entry <= 0;
		to_game_logic_received <= 0;	
		to_game_logic_done <= 0;
	        states <= IDLE;
	    end
	    else if (to_collision_ready) begin
		non_enemy_entry <= game_logic_to_collision;
		to_game_logic_received <= 0;	
		to_game_logic_done <= 0;
		states <= WAIT_RECEIVE;
	    end
	    else begin
		 if (states == WAIT_RECEIVE) begin
				states <= RECEIVE;
		 end
		else if (states == RECEIVE) begin
			enemy_entry <= game_logic_to_collision;
			to_game_logic_received <= 1;	
			to_game_logic_done <= 0;
			states <= PROCESS;	
		end
		else if (states == PROCESS) begin
			if (non_enemy_id == NO_ID) begin
				to_game_logic_received <= 0;	
				to_game_logic_done <= 1;
				states <= IDLE;
			end
			else if (enemy_id == NO_ID) begin
				to_game_logic_received <= 0;	
				to_game_logic_done <= 0;	
				states <= WAIT;
			end
			else begin
				to_game_logic_received <= 0;	
				to_game_logic_done <= 0;	
				states <= DIFF;
                        end
		end
		else if (states == WAIT) begin
			to_game_logic_received <= 0;	
			to_game_logic_done <= 0;
			states <= RECEIVE;	
		end
		else if (states == DIFF) begin
			if(non_enemy_x >= enemy_x )begin
				x_diff <= non_enemy_x - enemy_x;
			end
			else begin 
				x_diff <= enemy_x - non_enemy_x;
			end
			if (non_enemy_y >= enemy_y)begin 
				y_diff <= non_enemy_y - enemy_y;	
			end
			else begin
				y_diff <= enemy_y - non_enemy_y;
			end
			to_game_logic_received <= 0;	
			to_game_logic_done <= 0;
			states <= SQUARE;
		end
		else if (states == SQUARE) begin
			x_diff_sq <= x_diff * x_diff;
			y_diff_sq <= y_diff * y_diff;	
			to_game_logic_received <= 0;	
			to_game_logic_done <= 0;
			states <= COMPARE;
		end
		else if (states == COMPARE) begin
			if (x_diff_sq + y_diff_sq > non_enemy_r_sq + enemy_r_sq) begin
				to_game_logic_received <= 0;	
				to_game_logic_done <= 0;
				states <= RECEIVE;
			end
			else begin
				to_game_logic_received <= 0;	
				to_game_logic_done <= 1;
			        states <= IDLE;
			end
		end
		else if (states == IDLE) begin
			to_game_logic_received <= 0;	
			to_game_logic_done <= 0;
		        states <= IDLE;
		end
		else begin
			states <= PROCESS;
		end
	    end
	end

	always @(non_enemy_id) begin
		case (non_enemy_id)
			SHIP: non_enemy_r_sq = 13'd256;
			BULLET: non_enemy_r_sq = 13'd64;
	 		default: non_enemy_r_sq = 13'd256;
		endcase
	end

	always @(enemy_id) begin
		case (enemy_id)
			E1: enemy_r_sq = 13'd256;
			//E2: enemy_r_sq = 256;
			//E3: enemy_r_sq = 256;
	 		default: enemy_r_sq = 13'd256;
		endcase
	end
endmodule	
											
