`timescale 1ns/1ns
module game_logic_tb(output logic testout);
    logic clk;    // Clock
    logic reset;
    logic [31:0] movement_to_game_logic;  // output data from movement module
    logic movement_done; //movement module finishes its work
    logic draw_done; //Vga_Emulator finishes its work
    logic [15:0] x; //ship x
    logic [15:0] y; //ship y
    logic [15:0] x_b;//bullet x
    logic [15:0] y_b;//bullet y
    //logic [7:0] addr; //address for the RAM to choose data
   //logic we; //write enable for the RAM
    logic update_done; //Tell Vga_Emulator to start drawing
    logic [31:0] game_logic_to_movement;//data needed to be passed to movement module
    logic [31:0] game_logic_to_emulator;
    logic emulator_receive_en;
    logic ram_select;
    logic movement_ready; //tell movement module to start its work

game_logic dut(.*);

always #10 clk = ~clk;


initial begin
    clk = 1'd0;
    reset = 1'd1;
    draw_done = 1'd0;
    movement_done = 1'd0;
    x = 15'd240;
    y = 15'd300;
    x_b = 15'd0;
    y_b = 15'd0;
    @(posedge clk);
        reset = 1'd0;
    @(posedge clk);
        //movement_to_game_logic ={8'd1,10'd240,10'd400,4'd0};
		testout = movement_ready;
    #200; //spend 20 cycles to wait for movement to game logic
    @(posedge clk)
        movement_to_game_logic = {8'b00000001,10'd240,10'd300,4'd0};
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = 32'd0;
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = 32'd0;
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = 32'd0;
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        draw_done = 1;
    @(posedge clk);
        draw_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = {8'b0000_0001,10'd240,10'd300,4'd0};
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = {8'b0000_0010,10'd256,10'd316,4'd0};
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = 32'd0;
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
     #200;
    @(posedge clk);
        movement_to_game_logic = 32'd0;
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        draw_done = 1;
    @(posedge clk);
        draw_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = {8'b0000_0001,10'd240,10'd300,4'd0};
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = {8'b0000_0010,10'd262,10'd322,4'd0};
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        movement_to_game_logic = {8'b0000_0010,10'd256,10'd316,4'd0};
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
     #200;
    @(posedge clk);
        movement_to_game_logic = 32'd0;
        movement_done = 1;
    @(posedge clk);
        movement_done = 0;
    #200;
    @(posedge clk);
        draw_done = 1;
    @(posedge clk);
        draw_done = 0;

end

endmodule