module game_logic_spawnversion (
    input logic clk,    // Clock
    input logic reset,
    input logic [31:0] movement_to_game_logic,  // output data from movement module
    input logic movement_done, //movement module finishes its work
    input logic draw_done, //Vga_Emulator finishes its work
    input logic [15:0] x, //ship x
    input logic [15:0] y, //ship y
    input logic [15:0] x_b,//bullet x
    input logic [15:0] y_b,//bullet y
    //////////////////////////////////////////////
   // input logic [31:0] mem_out, //output of myram
   ////////////////////////////////////////////////////

 //   input logic [31:0] random,  //FFFF
	output logic [31:0] mem_in, //input of myram
    output logic [7:0] addr, //address for the RAM to choose data
    output logic we, //write enable for the RAM
    output logic update_done, //Tell Vga_Emulator to start drawing
    output logic [31:0] game_logic_to_movement,//data needed to be passed to movement module
	output logic show_all,
    output logic movement_ready //tell movement module to start its work
);
    logic [31:0] mem_out;
    logic movement_ready_delay;
    logic [3:0] bullet_cycle_counter;
    assign game_logic_to_movement = mem_out;

    /////////////////////////////////////////////////for testing
    myram ram_0(.show_all(show_all),.clk(clk), .we(we), .address(addr), .data_in(mem_in), .data_out(mem_out), .data_0(spaceship_data),.data_1(bullet1_data),.data_2(bullet2_data),.data_3(bullet3_data),.data_4(bullet4_data),.data_5(bullet5_data),.data_6(bullet6_data),.data_7(bullet7_data),.data_8(bullet8_data),.data_9(bullet9_data),.data_10(bullet10_data));
////////////////////////////////////////////////////////////////////
	 logic bullet_wait_pause;

     logic spawn_wait_pause;
     logic spawn_decide;
     logic [31:0] random;
    //State Definition
    random_number_generator randomnumber (.clock(clk), .seed(0), .*)
    enum logic [4:0] {done,reset_state, decide_spawn, premoving,moving,bullet, spawning} states; //FFFF
    always_ff @(posedge clk) begin
        if(reset) begin
            mem_in <= 0;
            we <= 0;
			addr <= 8'b0000_0000;
            update_done <= 0;
            movement_ready <= 0;
            states <= reset_state;

            bullet_cycle_counter <= 4'd0;
            show_all <= 0; //test
			//wait_cycle_count <= 3'd0;
			bullet_wait_pause <= 1'd0;
		//	bullet_decide <= 1'd0;
            spawn_wait_pause <= 1'd0;
        //    spawn_decide <= 1'd0;
        end

        else begin
            if (states == reset_state) begin
                //FFFF
                /*states <= bullet; //next cycle goes to bullet states
                */
                we <= 1;//next cycle, enable write for myram !!!!!!!!!!!!!  we = 1 next cycle !!!!!!!!!!!!!!!!
                mem_in <= {8'b0000_0001,x[9:0],y[9:0],x_b[1:0],y_b[1:0]};
                state <= decide_spawn;//next cycle goes to decide_spawn states

            end
            else if (states == decide_spawn) begin
                addr <= 8'd6;
                if (random[31:28] != 5'b00_000) begin
                    state <= premoving;
                    we <= 0; //disable the write enable for myram
                end
                else begin state <= spawning;
                     we <= 0;
                 end

            end

            else if (states == spawning) begin
                if (addr == 8'd10) begin //end of enermy, should generate non-enermy instead
                    addr <= 8'd6;
                    we <= 0;
                    state <= premoving; // if all occupied, go back to decide state to check if need to generate new enermy
                end
                else if (spawn_wait_pause) begin
                    state <= spawning;
                    spawn_wait_pause <= 1'd0;
                   // spawn_decide <= 1'd0

                end
                else if (mem_out[31:24] == 8'd0 & !spawn_wait_pause) begin
                    mem_in <= {8'd3, random[27:8], 4'd0}; //generate 1 enermy with direction of 0
                    we <= 1;
                    states <= premoving;
                    spawn_wait_pause <= 1'd0;
                end
                else begin
                    addr <= addr + 8'd1;
                 //   spawn_decide <= 1'd1;
                    spawn_wait_pause <= 1'd1;
                end
            end
            else if(states == bullet) begin
                if(bullet_cycle_counter != 4'd10/*for test only*/) begin //should we generate new bullet? yes for this case
                    states <= premoving;
                    we <= 0;//next cycle, disable write for myram
                end
                else begin //do not generate bullet
						  if(addr == 8'd10) begin //test only bound 12 //reach the bound 128 for bullet
                        addr <= 8'd1; //re-search the addr from 0
                        we <= 0;
                        states <= premoving;
                    end
						  else if (bullet_wait_pause) begin

								if (wait_cycle_count == 3'd0) begin
									states <= bullet;//what if all the address is occupied ?
									wait_cycle_count <= 3'd0;
									bullet_wait_pause <= 1'd0;
									//bullet_wait_pause<= 1'd0;
								end
						  end
                    else if (mem_out[31:24] == 8'b0000_0000 & !bullet_wait_pause) begin //at current addr, no thing in the myram
                        mem_in <={8'b0000_0010,x[9:0],y[9:0],x_b[1:0],y_b[1:0]};//intialize data about bullets
                        we <= 1; //next cycle, enable myram to be written
                        states <= premoving;
                        bullet_cycle_counter <= 4'd0; //reset counter, once generated
						bullet_wait_pause <= 1'd0;
                    end
                    else begin //at current addr, something occupied, try next addr
                        addr <= addr + 8'd1; //increase addr
								//bullet_decide <= 1;
								bullet_wait_pause <= 1'd1;
                        //we <= 0; //next cycle disable myram to be written
                    end
                end
            end
            else if(states == premoving) begin
                states <= moving; //next cycle goes to moving states
                movement_ready_delay <= 1; //next next cycle, movement can updata (look at last line in moving state)
                we <= 0; //next cycle, the value in the myram cannot be changed
                addr <= 8'd0;
            end
            else if(states == moving) begin
                if(movement_done) begin  //if movement module finishes its jobs
                    mem_in <= movement_to_game_logic; //take data from movemnet module and update its value in next cycle
                    we <= 1; //next cycle, enable movement module
                    movement_ready_delay <= 0; //next cycle, make movement could not process data from mem_out
                        //if(addr == 8'd255) begin //every item in myram has been updated
                        if (addr == 8'd10) begin //for test only
                            update_done <= 1;
							show_all <= 1;
                            states <= done;
                            //addr <= 8'd0;
                        end
                end
                else if(we) begin //if last cycle, we = 1, it means that, at this cycle, data at addr will be updated. then we should updata the value in addr+1 next
                    addr <= addr+1; //update address
                    movement_ready_delay <= 1; //next cycle, movement module could update value at addr+1
                    we <= 0; //next cycle, myram could not be changed
                end
                else begin
                    movement_ready_delay <= 0; //if not above cases, means movement moudle is processing the data it recieved last time, disable it to process new data
                end
                movement_ready <= movement_ready_delay;//if movement_ready_delay is 1 (0) at this cycle, then next cycle movement_ready will be 1 (0).
            end
            else if(states == done) begin
                states <= done;
                we <= 0;
					 addr <= 8'd1;
                //show_all <=1;
					 update_done <= 0;
					 if(draw_done == 1) begin //vga_emulator finishes its job, it's time to update
							states <= bullet;
							show_all <= 0;

							bullet_cycle_counter <= bullet_cycle_counter + 4'd1; //when draw_done, increase bullet_cycle_counter, until it reaches 8. (see bullet states)
						end
				end
        end
    end
endmodule