// game_logic + movement
module game_logic_movement( input logic clk,
    input logic reset,
    input logic [15:0] writedata,
    input logic [2:0] address,
    input logic    write,
    input logic    chipselect,

    output logic [7:0] VGA_R, VGA_G, VGA_B,
    output logic       VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
    output logic       VGA_SYNC_n);
   /* output logic [31:0] movement_to_game_logic,
    output logic movement_done);*/

logic [15:0]    x, y, x_b, y_b;
logic [7:0]          entity;
logic [31:0]    game_logic_to_movement_tmp;
logic movement_ready_tmp;
logic [31:0]    movement_to_game_logic_tmp;
logic movement_done_tmp;
logic draw_done_tmp;
logic update_done_tmp;

game_logic gamelogic(.clk(clk), .reset(reset), .update_done(update_done_tmp), .draw_done(draw_done_tmp), .x(x), .y(y), .x_b(x_b), .y_b(y_b), .movement_to_game_logic(movement_to_game_logic_tmp), .movement_done(movement_done_tmp), .game_logic_to_movement(game_logic_to_movement_tmp), .movement_ready(movement_ready_tmp));
movement movement_yeah(.clk(clk), .reset(reset), .game_logic_to_movement(game_logic_to_movement_tmp), .movement_ready(movement_ready_tmp), .movement_to_game_logic(movement_to_game_logic_tmp), .movement_done(movement_done_tmp));

VGA_BALL_Emulator ball_emulator(.clk50(clk), .draw_done(draw_done_tmp), .update_done(update_done_tmp), .*);

always_ff @(posedge clk) begin
    if (reset) begin
        x <= 16'd320;
        y <= 16'd220;
        x_b <= 16'd0;
        y_b <= 16'd0;


    end
    else if (chipselect && write) begin
        entity <= 8'd0;

        case (address)
            3'h0 : x <= writedata;
            3'h1 : y <= writedata;
            3'h2 : x_b <= writedata;
            3'h3 : y_b <= writedata;

            default: x <= x;
        endcase
    end
end
endmodule