`timescale 1ns/1ns

module emulator_tb (output logic testout);
	logic       clk50, reset;
    logic enable_ram;
    logic ram_select;
    logic update_done;//game logic says you can work
    logic [31:0] ram_out_a;
    logic [31:0] ram_out_b;
    logic draw_done;//tell game logic you finish
	logic [7:0] VGA_R, VGA_G, VGA_B;
	logic      VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n;

    logic  [23:0]   color_spaceship;
    logic  [23:0]   color_background;
    logic  [23:0]   color_bullet;

	//logic clk;    // Clock
    /*
    logic we; // Write Enable
    logic [31:0] data_in_a;  // Input data
    logic [7:0] address_a;
    logic [31:0] data_in_b;  // Input data
    logic [7:0] address_b;*/

VGA_BALL_Emulator emulator_wow(.*);
////myram ramaaaaa(.clk(clk50), .data_in(data_in_a), .data_out(ram_out_a), .address(address_a), .*);
//myram rambbbbb(.clk(clk50), .data_in(data_in_b), .data_out(ram_out_b), .address(address_b), .*);

always #10 clk50 = ~clk50;

initial begin
    clk50 = 1'd0;
    reset = 1'd0;
    enable_ram = 1'd0;
    ram_select = 1'd0;
    update_done = 1'd0;
    ram_out_a = 32'd0;
    ram_out_b = 32'd0;
    /*we = 0;
    data_in_a = 32'd0;
    data_in_b = 32'd0;
    address_b = 8'd0;
    address_a = 8'd0;*/

end

initial begin
    #10 @(posedge clk50);
    reset = 1'd1;
    @(posedge clk50);
    reset = 1'd0;
    enable_ram = 1'd1;
    ram_select = 1'd1;
    ram_out_a = {8'd0, 10'd1, 10'd2, 4'd3};
    ram_out_b = {8'd0, 10'd2, 10'd3, 4'd4};
    color_bullet = 24'd129;
    color_background = 24'd328749;
    color_spaceship = 24'd3959;

    @(posedge clk50);
    ram_select = 1'd0;
    ram_out_a = {8'd0, 10'd6, 10'd7, 4'd3};
    ram_out_b = {8'd0, 10'd8, 10'd9, 4'd4};

    @(posedge clk50);
    enable_ram = 1'd0;

    @(posedge clk50);
    enable_ram = 1'd1;
    ram_select = 1'd1;
    ram_out_a = {8'd0, 10'd10, 10'd11, 4'd3};
    ram_out_b = {8'd0, 10'd12, 10'd13, 4'd4};

    @(posedge clk50);
    ram_select = 1'd0;
    ram_out_a = {8'd0, 10'd14, 10'd15, 4'd3};
    ram_out_b = {8'd0, 10'd16, 10'd17, 4'd4};

    @(posedge clk50);
    enable_ram = 1'd0;

    @(posedge clk50);
    enable_ram = 1'd1;
    ram_select = 1'd1;
    ram_out_a = {8'd0, 10'd20, 10'd21, 4'd3};
    ram_out_b = {8'd0, 10'd22, 10'd23, 4'd4};

    @(posedge clk50);
    ram_select = 1'd0;
    ram_out_a = {8'd0, 10'd24, 10'd25, 4'd3};
    ram_out_b = {8'd0, 10'd26, 10'd27, 4'd4};

    @(posedge clk50);
    enable_ram = 1'd0;

end



endmodule