module audio_effects (
    input  clk,
    input  sample_end,
    input  sample_req,
    output [15:0] audio_output,
    input  [15:0] audio_input,
    input  [3:0]  control,
	 input  flag_audio_bullet,
	 input flag_audio_collision
);

//reg [15:0] romdata [0:622];
//reg [9:0]  index = 10'd0;
logic [15:0] last_sample; //reg
logic [15:0] dat; //reg
//logic [15:0] dat_collision;
logic [15:0]  audio_bullet_addr;  //reg
logic [14:0]  audio_collision_addr; 
assign audio_output = dat;
//assign audio_output_collision = dat_collision;   

logic flag_bullet;
logic flag_collision;
//logic [11:0] playaudio_counter;
//assign playaudio_counter = 12'd0;

logic [15:0] audio_bullet_data; //wire
logic [15:0] audio_collision_data;

parameter PLAY     = 0;
parameter FEEDBACK = 1;

assign flag_bullet = flag_audio_bullet;
assign flag_collision = flag_audio_collision;

rom_audio_bullet audiobulletrom(.address(audio_bullet_addr), .clock(clk), .q(audio_bullet_data));
rom_audio_collision audiocollisionrom(.address(audio_collision_addr), .clock(clk), .q(audio_collision_data));

enum logic [2:0] {start_bullet,start_collision,stop} states;

always @(posedge clk) begin
    //if (flag) begin
    if (sample_end) begin
        last_sample <= audio_input;
    end
	 //states reset, if board SW[0] OFF
    if (control [PLAY] == 0) begin
		  states <= stop;
	 end
	 //If shoot bullet, enter start state
	 if (states == stop) begin//xxxxxxxxxxxxxxxxxxxxxxxx	
		if (flag_collision == 1) begin
		  states <= start_collision;
		end
		
      else if (flag_bullet == 1 && flag_collision != 1) begin  //original:sample_req
		  states <= start_bullet; //xxxxxxxxxxxxxxxxx
		end //xxxxxxxxxxxxxxxx
		
	 end
	 //If sample_req == 1 (for one cycle), read out one data (totally 4000 sample data)
    if (states == start_bullet) begin
		 if (sample_req) begin
		     if (control[FEEDBACK]) begin
               dat <= last_sample;
			  end      
			  else if (control[PLAY]) begin  //xxxxxxxxxxxxxxxxxxxxxxxxxxx
			      dat <= audio_bullet_data;
					if (audio_bullet_addr == 16'd35945) begin
                   audio_bullet_addr <= 16'd00;
						 states <= stop;
					end
					else begin
                   audio_bullet_addr <= audio_bullet_addr + 1'b1;	
					end
			  end
			  else begin
			      dat <= 16'd0;					
			  end 
	    end
	 end
	 
    if (states == start_collision) begin
		 if (sample_req) begin
		     if (control[FEEDBACK]) begin
               dat <= last_sample;
			  end
			  else if (control[PLAY]) begin  //xxxxxxxxxxxxxxxxxxxxxxxxxxx
			      dat <= audio_collision_data;
					if (audio_collision_addr == 15'd30871) begin
                   audio_collision_addr <= 15'd00;
						 states <= stop;
					end
					else begin
                   audio_collision_addr <= audio_collision_addr + 1'b1;	
					end
			  end
			  else begin
			      dat <= 16'd0;					
			  end 
	    end
	 end
	 
end

endmodule
