module audio_codec (
    input  clk,
    input  reset,
    output [1:0]  sample_end,
    output [1:0]  sample_req,
    input  [15:0] audio_output,
    output [15:0] audio_input,
    // 1 - left, 0 - right
    input  [1:0] channel_sel,

    output AUD_ADCLRCK,
    input AUD_ADCDAT,
    output AUD_DACLRCK,
    output AUD_DACDAT,
    output AUD_BCLK
);

logic [10:0] lrck_divider;  //d 1536= b 11000 0000 00
logic [1:0] bclk_divider;

logic [15:0] shift_out;
logic [15:0] shift_temp;
logic [15:0] shift_in;

logic lrck;
assign lrck = !((lrck_divider[8] ==1) && (lrck_divider[9] ==1));//!lrck_divider[7];

assign AUD_ADCLRCK = lrck;
assign AUD_DACLRCK = lrck;
assign AUD_BCLK = bclk_divider[1];
assign AUD_DACDAT = shift_out[15];

always @(posedge clk) begin
    if (reset) begin
        lrck_divider <= 11'h5ff;  //10111 1111
        bclk_divider <= 2'b11;
    end else begin
        bclk_divider <= bclk_divider + 1'b1;
		  if (lrck_divider == 11'd1536)
		  lrck_divider <= 11'h0;
		  else 
		  lrck_divider <= lrck_divider + 1'b1;
    end
end

assign sample_end[1] = (lrck_divider == 11'd384);
assign sample_end[0] = (lrck_divider == 11'd1152);
assign audio_input = shift_in;
assign sample_req[1] = (lrck_divider == 11'd1534);
assign sample_req[0] = (lrck_divider == 11'd766);

logic clr_lrck;
assign clr_lrck = (lrck_divider == 11'd767);
logic set_lrck;
assign set_lrck = (lrck_divider == 11'd1535);
// high right after bclk is set
logic set_bclk;
assign set_bclk = (bclk_divider == 2'b10 && !lrck_divider[6]);
// high right before bclk is cleared
logic clr_bclk;
assign clr_bclk = (bclk_divider == 2'b11 && !lrck_divider[6]);

always @(posedge clk) begin
    if (reset) begin
        shift_out <= 16'h0;
        shift_in <= 16'h0;
        shift_in <= 16'h0;
    end else if (set_lrck || clr_lrck) begin
        // check if current channel is selected
        if (channel_sel[set_lrck]) begin
            shift_out <= audio_output;
            shift_temp <= audio_output;
            shift_in <= 16'h0;
        // repeat the sample from the other channel if not
        end else shift_out <= shift_temp;
    end else if (set_bclk == 1) begin
        // only read in if channel is selected
        if (channel_sel[lrck])
            shift_in <= {shift_in[14:0], AUD_ADCDAT};
    end else if (clr_bclk == 1) begin
        shift_out <= {shift_out[14:0], 1'b0};
    end
end

endmodule
