// game_logic + movement
module VGA_BALL( 
    input logic clk,
    input logic reset,
    input logic [15:0] writedata,
    input logic [8:0] address,  //address for transimitting 240 data values
    input logic    write,
    input logic    chipselect,

    output logic [7:0] VGA_R, VGA_G, VGA_B,
    output logic       VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
    output logic       VGA_SYNC_n);
   /* output logic [31:0] movement_to_game_logic,
    output logic movement_done);*/

logic [31:0] movement_to_game_logic;
logic movement_done;
logic draw_done;
logic [15:0] x;
logic [15:0] y;
logic [15:0] x_b;
logic [15:0] y_b;
logic update_done;
logic [31:0] game_logic_to_movement;
logic [31:0] game_logic_to_emulator;
logic emulator_receive_en;
logic ram_select;
logic movement_ready;

//added logic for transmitting data from sofeware to hardware
reg [31:0] data [0:59];

//-----logic for collision module-----xx&JS
logic [31:0] to_collision_entry; //entity info data sent to collision module
logic from_collision_received, from_collision_done; //signal from collision module 
logic to_collision_ready;//signal to collision indicating ready for sending entity 
logic [15:0] score;
logic avatar_initial;


game_logic gamelogic(.*);   //input ports to be added to get the data updated in game_logic 
movement movement_yeah(.x_ship(x),.y_ship(y),.clk(clk), .reset(reset), .game_logic_to_movement(game_logic_to_movement), .movement_ready(movement_ready), .movement_to_game_logic(movement_to_game_logic), .movement_done(movement_done));
VGA_BALL_Emulator ball_emulator(.*,.clk50(clk), .draw_done(draw_done), .update_done(update_done),.enable_ram(emulator_receive_en),.ram_select(ram_select),.game_logic_to_emulator(game_logic_to_emulator));
//VGA_BALL_Emulator ball_emulator(.*,.clk50(clk), .draw_done(draw_done), .update_done(update_done),.enable_ram(emulator_receive_en),.ram_select(ram_select),.game_logic_to_emulator(game_logic_to_emulator));


always_ff @(posedge clk) begin
    if (reset) begin
        x <= 16'd320;
        y <= 16'd220;
        x_b <= 16'd0;
        y_b <= 16'd0;


    end
    else if (chipselect && write) begin
        case (address)
            9'h0 : data[0][31:24] <= writedata;
            9'h1 : data[0][23:14] <= writedata;
            9'h2 : data[0][13:4] <= writedata;
            9'h3 : data[0][3:0] <= writedata;
            9'h4 : data[1][31:24] <= writedata;
            9'h5 : data[1][23:14] <= writedata;
            9'h6 : data[1][13:4] <= writedata;
            9'h7 : data[1][3:0] <= writedata;
            default: x <= x;
        endcase
    end
end
endmodule