/* This module is the connection between the software and vga_emulator
*  It takes the messages sends from software, reorganize and store the message[0]to message[255]
*  into[31:0]data1[0:63] or [31:0]data2[0:63] alternately
*  The VGA_Emulator module takes the data from either data1 or data2 as the information to draw
*
*  Zhenyu Zhu, Fang Fang, Columbia University
*/
module VGA_BALL( input logic clk,
    input logic reset,
    input logic [15:0] writedata,
    input logic [7:0] address,
    input logic write,
    input logic chipselect,
    output logic VGA_audio_bullet,VGA_audio_collision,
    output logic [7:0] VGA_R, VGA_G, VGA_B,
    output logic       VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
    output logic       VGA_SYNC_n);

	logic draw_done; //emulator finishes its work
	logic update_done;//emulator could start work
	logic enable_ram;//ram in emluator could start receive info
	logic ram_select;//choose which ram is used to store info
	logic end_writedata_to_data;
	logic end_data_to_emulator;
	logic [1:0] e_counter2;	//added logic for sending data to emulator in multiple cycles
	logic [7:0] e_counter3;  //reset state counter
	logic en_emulator;      //enable the ram in Emulator to store the data
	logic [1:0] life;
	logic [1:0] bomb_value;
	logic [9:0] score;
	logic [3:0] tens;   // the decade digit for the score
	logic [3:0] digits;  // the unit digit for the score
	logic game_over;   // indicating the lifes of the avatar have been used up and restart the game
	reg [9:0] data1 [0:255];//reg used to store info
	reg [9:0] data2 [0:255];//reg used to store info
	logic [31:0] data_to_emulator;
	logic [31:0] data_to_emulator_tmp;
	logic [9:0] data_index;
	logic [31:0] A;
	logic [31:0] B;
	logic [31:0] C;
	logic [31:0]A_in;
	logic [31:0]B_in;
	logic [31:0]C_in;
	logic [31:0] mem_out_u,mem_out,ram_out;
	//states makes this work
	enum logic [2:0] {reset_states, processing} states;
	enum logic[3:0] {idle, wait_stable, process_data, transfer_data} sub_states;

	VGA_BALL_Emulator ball_emulator(.*,.clk50(clk), .draw_done(draw_done), .update_done(update_done),.enable_ram(enable_ram),.ram_select(ram_select),.game_logic_to_emulator(data_to_emulator), .A(A), .B(B), .C(C));

	always_ff @(posedge clk) begin
	    if (reset) begin
			  ram_select <= 0;
			  data_to_emulator <= 0;
			  data_index <= 0;
			  enable_ram <= 1;
			  update_done <= 1;
			  e_counter2 <= 0;
			  e_counter3 <=0;
			  states <= reset_states;
			  game_over <= 1;
		end
		//give the intial value to emulator
		else if (states == reset_states)begin
			  if (e_counter3== 8'd0) begin
					data1[e_counter3] <= 10'd1;
					data2[e_counter3] <= 10'd1;
					e_counter3 <= e_counter3 + 1;
			  end
		  else if (e_counter3 == 8'd1)begin
				data1[e_counter3] <= 10'd320;
				data2[e_counter3] <= 10'd320;
				e_counter3 <= e_counter3 + 1;
		  end
		  else if (e_counter3 == 8'd2)begin
				data1[e_counter3] <= 10'd240;
				data2[e_counter3] <= 10'd240;
				e_counter3 <= e_counter3 + 1;
		  end
		  else if (e_counter3 == 8'd3)begin
		      data1[e_counter3] <= 10'd0;
		  		data2[e_counter3] <= 10'd0;
				e_counter3 <= 0;
		      states<=processing;
		      sub_states <= wait_stable;
		  end
		end
		//Start to receive info from software and
		//tranfer the data to VGA_BALL_Emulator
		else if (states == processing) begin
			if (chipselect && write) begin
				if (address <= 8'd255) begin
					if(address == 8'd240) life <= writedata;
					else if (address == 8'd255) game_over <= writedata;
					else if (address == 8'd248) digits <= writedata;
					else if (address == 8'd247) tens <= writedata;
					else if(address == 8'd241) score <= writedata;
					else if(address == 8'd242) bomb_value <= writedata;
					//when ram_select is 0, store the writedata into data1
					if(ram_select == 0) data1[address] <= writedata;
					//when ram_select is 1, store the writedata into data2
					else data2[address] <= writedata;
					if(address ==  8'd255) end_writedata_to_data <= 1;
				end
			end
			////end of software data transmission
			else end_writedata_to_data <= 1;

			//added counter to control multiple cycles to send data to emulator
			if(enable_ram==1) begin
				if(data_index!=10'd64)begin
					//fetch data from data1 or data 2 and store it in tem reg
					if(sub_states==wait_stable)begin
						if(e_counter2==0)begin
							data_to_emulator_tmp[31:24] <= ram_select?data1[4*data_index]:data2[4*data_index];
							e_counter2 <= e_counter2 + 1;
						end
						else if(e_counter2==1)begin
							data_to_emulator_tmp[23:14] <= ram_select?data1[4*data_index+1]:data2[4*data_index +1];
							e_counter2 <= e_counter2 + 1;
						end
						else if(e_counter2==2)begin
							data_to_emulator_tmp[13:4] <= ram_select?data1[4*data_index+2]:data2[4*data_index+2];
							e_counter2 <= e_counter2 +1;
						end
						else if(e_counter2==3)begin
							data_to_emulator_tmp[3:0] <= ram_select?data1[4*data_index+3]:data2[4*data_index+3];
							e_counter2 <= 0;
							sub_states <= transfer_data;
						end
					end
					//start to transfer the data to VGA_BALL_Emulator
					else if (sub_states == transfer_data)begin
						data_to_emulator<=data_to_emulator_tmp;
						en_emulator <= 1;   //enable the ram in the VGA_BALL_Emulator to store the data
						sub_states <= process_data;
						//receive audio info set flags or clear flags
						if (data_index == 10'd61)begin
							VGA_audio_bullet <= data_to_emulator_tmp[14];
							VGA_audio_collision <= data_to_emulator_tmp[24];
						end
					end
					//keeping fetching data and sending it out until it finsihes transmitting 64 objects
					else if(sub_states==process_data)begin
						VGA_audio_bullet <= 0;
						VGA_audio_collision <= 0;
						en_emulator <= 0;
						data_index <= data_index + 1;
						sub_states <= wait_stable;
					end
				end
				else begin
					data_index <=0;
					end_data_to_emulator <= 1;
					enable_ram <= 0;
				end
			end
			//when finishing receiving 256 messages from the software as well as finishing transmitting
            // 64 objects to the emulator, wait the emulator to finish its drawing
			//and restart emulator to draw.
			if(end_data_to_emulator & end_writedata_to_data)begin
				if(draw_done)begin
					update_done <= 1;  // indicating the emulator could restart to draw from (0,0)
                    /*toggle the select bit to alternate the updating reg(from the software) and the transmitting reg (to the Emulator)*/
					ram_select <= ~ram_select;
					end_data_to_emulator <= 0;
					end_writedata_to_data <=0;
					enable_ram <= 1;
				end
			end
			else update_done <= 0;

		end
	end

endmodule
