module symbolcam(  	input logic clk,reset,
			input logic [63:0] symbol,
			output logic validcam,error,
			output logic [7:0] addr);

    	parameter symbolwidth = 4;
    	parameter depth = symbolwidth;
    
    	logic [63:0] lutable [0:depth-1];
	logic flag;
    	integer i;

	assign lutable[0] = {24'h414D43,40'd0};		//AMC
	assign lutable[1] = {24'h4E5954,40'd0};		//NYT: New York Times Company
	assign lutable[2] = {24'h51544D,40'd0};		//QTM: Quantum Corp
	assign lutable[3] = {32'h594F4B55,32'd0};	//YOKU: Youku.Com Inc

   	initial begin
        error=1;
        validcam=0;
        addr=8'd0;
	flag=0;
    	end
    

	always_ff@(posedge clk) begin
		if(reset) begin
            	addr<=8'd0;
            	error<=1;
            	validcam<=0;
		flag<=0;
        	end

		else begin
		   	if(symbol==64'd0)begin
				validcam<=0;
		        	error<=1;
		        	addr<=8'd0;
				flag<=0;
			end

			else if(symbol!=64'd0)begin
				validcam <= 1;
				for(i=0; i<depth; i++) begin
					if(symbol==lutable[i][63:0] && flag==0)begin
						flag <= 1;
						error <= 0;
						addr <= (8'd1)*i;
					end

				end
			end
		end
	end
			
endmodule
