module preprocessor_down( input logic clk,reset,
			input logic validpar,
			input logic [31:0] tag,
			input logic [167:0] value,
			output logic readypreproc, validpreproc,
			output logic [15:0] vmsgtype,
			output logic[31:0] vlastqty,
			output logic[63:0] vsendid, vtargid, vsymbol,
			output logic[7:0] vside);

	integer i;
	integer j;

	logic[9:0][7:0] value0;
	logic found_qty;

	assign value0[9][7:0] = value[167:160];
	assign value0[8][7:0] = value[159:152];
	assign value0[7][7:0] = value[151:144];
	assign value0[6][7:0] = value[143:136];	
	assign value0[5][7:0] = value[135:128];
	assign value0[4][7:0] = value[127:120];
	assign value0[3][7:0] = value[119:112];
	assign value0[2][7:0] = value[111:104];
	assign value0[1][7:0] = value[103:96];
	assign value0[0][7:0] = value[95:88];

	typedef enum logic [1:0]{READ,OUTPUT} state_t;
	state_t state;

	initial begin
	readypreproc = 1;
	validpreproc = 0;
	state = READ;
	found_qty = 0;
	vmsgtype[15:0] = 16'd0;
	vlastqty[31:0] = 32'd0;
	vsendid[63:0] = 64'd0;
	vtargid[63:0] = 64'd0;
	vsymbol[63:0] = 64'd0;
	vside[7:0] = 8'd0;
	end
	
	always_ff@(posedge clk) begin
		if(reset) begin
			readypreproc = 1;
			validpreproc = 0;
			state <= READ;
			found_qty = 0;
			vmsgtype[15:0] = 16'd0;
			vlastqty[31:0] = 32'd0;
			vsendid[63:0] = 64'd0;
			vtargid[63:0] = 64'd0;
			vsymbol[63:0] = 64'd0;
			vside[7:0] = 8'd0;
	   	end
		
		else case(state)
			READ: begin
				if(validpar == 0) ;
				else if(tag == 32'h38000000) begin
							vmsgtype[15:0] = 16'd0;
        						vlastqty = 32'd0;
							found_qty = 0;
							vsendid[63:0] = 64'd0;
							vtargid[63:0] = 64'd0;
							vsymbol[63:0] = 64'd0;
							vside[7:0] = 8'd0;
							end

				else if(tag == 32'h33350000) 	vmsgtype[15:0] <= value[167:152];

        			else if(tag == 32'h33320000) 	begin
								for(i=0; i<10; i=i+1)begin
									if(value0[i][7:0] && !found_qty)begin
										found_qty = 1;
										for(j=0; j<10-i; j=j+1)begin
											vlastqty = vlastqty + (value0[j+i][7:0]-8'h30)*((8'd10)**j);
										end
									end
								end
								end

				else if(tag == 32'h35360000) vsendid[63:0] <= value[167:104];
				else if(tag == 32'h34390000) vtargid[63:0] <= value[167:104];
				else if(tag == 32'h35350000) vsymbol[63:0] <= value[167:104];
				else if(tag == 32'h35340000) vside[7:0] <= value[167:160];
				else if(tag == 32'h31300000) 	begin 
								state <= OUTPUT;
								readypreproc <= 0;
								validpreproc <= 1;
								end
				end

			OUTPUT: begin
					readypreproc <= 1;
					validpreproc <= 0;
					state <= READ;

				end
		endcase
	end
endmodule
