module preprocessor( input logic clk,reset,
			input logic validpar,
			input logic [31:0] tag,
			input logic [167:0] value,
			output logic readypreproc, validpreproc,
			output logic [15:0] vmsgtype,
			output logic[31:0] vseqnum, vordqty,
			output logic[31:0] vprice,
			output logic[63:0] vsendid, vtargid, vsymbol,
			output logic[95:0] vsendtime1,
			output logic[31:0] vsendtime2,
			output logic[95:0] vtranstime1,
			output logic[31:0] vtranstime2,
			output logic[7:0] vside, vordtype);

	integer i;
	integer j;

	logic[9:0][7:0] value0;
	logic found_seq;
	logic found_qty;
	logic found_pric;

	assign value0[9][7:0] = value[167:160];
	assign value0[8][7:0] = value[159:152];
	assign value0[7][7:0] = value[151:144];
	assign value0[6][7:0] = value[143:136];	
	assign value0[5][7:0] = value[135:128];
	assign value0[4][7:0] = value[127:120];
	assign value0[3][7:0] = value[119:112];
	assign value0[2][7:0] = value[111:104];
	assign value0[1][7:0] = value[103:96];
	assign value0[0][7:0] = value[95:88];

	typedef enum logic [1:0]{READ,OUTPUT} state_t;
	state_t state;

	initial begin
	readypreproc = 1;
	validpreproc = 0;
	state = READ;
	found_seq = 0;
	found_qty = 0;
	found_pric = 0;
	vmsgtype[15:0] = 16'd0;
	vseqnum = 32'd0;
        vordqty = 32'd0;
	vprice = 32'd0;
	vsendid[63:0] = 64'd0;
	vtargid[63:0] = 64'd0;
	vsymbol[63:0] = 64'd0;
	vsendtime1 = 96'd0;
	vsendtime2 = 32'd0;
	vtranstime1 = 96'd0;
	vtranstime2 = 32'd0;
	vside[7:0] = 8'd0;
	vordtype[7:0] = 8'd0;
	end
	
	always_ff@(posedge clk) begin
		if(reset) begin
			readypreproc = 1;
			validpreproc = 0;
			state <= READ;
			found_seq = 0;
			found_qty = 0;
			found_pric = 0;
			vmsgtype[15:0] = 16'd0;
			vseqnum = 32'd0;
        		vordqty = 32'd0;
			vprice = 32'd0;
			vsendid[63:0] = 64'd0;
			vtargid[63:0] = 64'd0;
			vsymbol[63:0] = 64'd0;
			vsendtime1 = 96'd0;
			vsendtime2 = 32'd0;
			vtranstime1 = 96'd0;
			vtranstime2 = 32'd0;
			vside[7:0] = 8'd0;
			vordtype[7:0] = 8'd0;
	   	end
		
		else case(state)
			READ: begin
				if(validpar == 0) ;
				else if(tag == 32'h38000000) begin
							vmsgtype[15:0] = 16'd0;
							vseqnum = 32'd0;
        						vordqty = 32'd0;
							found_seq = 0;
							found_qty = 0;
							found_pric = 0;
							vsendid[63:0] = 64'd0;
							vtargid[63:0] = 64'd0;
							vsymbol[63:0] = 64'd0;
							vsendtime1 = 96'd0;
							vsendtime2 = 32'd0;
							vtranstime1 = 96'd0;
							vtranstime2 = 32'd0;
							vside[7:0] = 8'd0;
							vordtype[7:0] = 8'd0;
							end

				else if(tag == 32'h33350000) 	vmsgtype[15:0] <= value[167:152];

				else if(tag == 32'h33340000) 	begin
								for(i=0; i<10; i=i+1)begin
									if(value0[i][7:0] && !found_seq)begin
										found_seq = 1;
										for(j=0; j<10-i; j=j+1)begin
											vseqnum = vseqnum + (value0[j+i][7:0]-8'h30)*((32'd10)**j);
										end
									end
								end
								end

        			else if(tag == 32'h33380000) 	begin
								for(i=0; i<10; i=i+1)begin
									if(value0[i][7:0] && !found_qty)begin
										found_qty = 1;
										for(j=0; j<10-i; j=j+1)begin
											vordqty = vordqty + (value0[j+i][7:0]-8'h30)*((8'd10)**j);
										end
									end
								end
								end
        			else if(tag == 32'h34340000) 	begin
								for(i=0; i<10; i=i+1)begin
									if(value0[i][7:0] && !found_pric)begin
										found_pric = 1;
										for(j=0; j<10-i; j=j+1)begin
											vprice = vprice + (value0[j+i][7:0]-8'h30)*((8'd10)**j);
										end
									end
								end
								end
				else if(tag == 32'h34390000) vsendid[63:0] <= value[167:104];
				else if(tag == 32'h35360000) vtargid[63:0] <= value[167:104];
				else if(tag == 32'h35350000) vsymbol[63:0] <= value[167:104];
				else if(tag == 32'h35320000) 	begin
								vsendtime1[95:0] <= value[167:72];
								vsendtime2[31:0] <= ((value[71:64]-8'h30)*32'd600000) + ((value[63:56]-8'h30)*32'd60000) + ((value[47:40]-8'h30)*32'd10000) + ((value[39:32]-8'h30)*32'd1000) + ((value[23:16]-8'h30)*32'd100) + ((value[15:8]-8'h30)*32'd10) + ((value[7:0]-8'h30)*32'd1);
								end
				else if(tag == 32'h36300000) 	begin
								vtranstime1[95:0] <= value[167:72];
								vtranstime2[31:0] <= ((value[71:64]-8'h30)*32'd600000) + ((value[63:56]-8'h30)*32'd60000) + ((value[47:40]-8'h30)*32'd10000) + ((value[39:32]-8'h30)*32'd1000) + ((value[23:16]-8'h30)*32'd100) + ((value[15:8]-8'h30)*32'd10) + ((value[7:0]-8'h30)*32'd1);
								end
				else if(tag == 32'h35340000) vside[7:0] <= value[167:160];
				else if(tag == 32'h34300000) vordtype[7:0] <= value[167:160];
				else if(tag == 32'h31300000) 	begin 
								state <= OUTPUT;
								readypreproc <= 0;
								validpreproc <= 1;
								end
				end

			OUTPUT: begin

					readypreproc <= 1;
					validpreproc <= 0;
					state <= READ;


				end
		endcase
	end
endmodule
