module floatram(	input logic clk,
		input logic reset,
		input logic[7:0] idindex,
		input logic[7:0] symbolindex,
		input logic iderror,
		input logic symbolerror,
		input logic idvalid,
		input logic symbolvalid,
		input logic[15:0] msgtype,
		input logic[7:0] side,
		input logic[31:0] qty,
		input logic[15:0] msgtypeD,
		input logic[7:0] idindexD,
		input logic[7:0] symbolindexD,
		input logic idvalidD,
		input logic symbolvalidD,
		input logic iderrorD,
		input logic symbolerrorD,
		input logic[7:0] sideD,
		input logic[31:0] qtyD,
		output logic flag,
		output logic valid,
		output logic validD);		//flag == 1, through; flag == 0, drop

	parameter idnum = 4;
	parameter symbolnum = 4;
	parameter ramdepth = idnum*symbolnum;

	logic[0:ramdepth-1][31:0] buylimit;
	logic[0:ramdepth-1][31:0] selllimit;
	logic[0:ramdepth-1][31:0] buyfloat;
	logic[0:ramdepth-1][31:0] sellfloat;
	integer i;
	logic flag_up;
	logic flag_down;
	
	assign buylimit[0] = 32'd0;
	assign buylimit[1] = 32'd0;
	assign buylimit[2] = 32'd10;
	assign buylimit[3] = 32'd100;
	assign buylimit[4] = 32'd1000;
	assign buylimit[5] = 32'd10000;
	assign buylimit[6] = 32'd100000;
	assign buylimit[7] = 32'd1000000;
	assign buylimit[8] = 32'd10000000;
	assign buylimit[9] = 32'd100000000;
	assign buylimit[10] = 32'd10000000;
	assign buylimit[11] = 32'd1000000;
	assign buylimit[12] = 32'd100000;
	assign buylimit[13] = 32'd10000;
	assign buylimit[14] = 32'd1000;
	assign buylimit[15] = 32'd100;

	assign selllimit[0] = 32'd0;
	assign selllimit[1] = 32'd0;
	assign selllimit[2] = 32'd10;
	assign selllimit[3] = 32'd100;
	assign selllimit[4] = 32'd1000;
	assign selllimit[5] = 32'd10000;
	assign selllimit[6] = 32'd100000;
	assign selllimit[7] = 32'd1000000;
	assign selllimit[8] = 32'd10000000;
	assign selllimit[9] = 32'd100000000;
	assign selllimit[10] = 32'd10000000;
	assign selllimit[11] = 32'd1000000;
	assign selllimit[12] = 32'd10000;
	assign selllimit[13] = 32'd10000;
	assign selllimit[14] = 32'd1000;
	assign selllimit[15] = 32'd100;

	initial begin
	for(i=0; i<ramdepth; i=i+1) buyfloat[i] = 32'd0;
	for(i=0; i<ramdepth; i=i+1) sellfloat[i] = 32'd0;
	flag = 1;
	valid = 0;
	validD = 0;
	flag_up = 0;
	flag_down = 0;
	end

	always_ff@(posedge clk) begin
		if(reset) begin
			for(i=0; i<ramdepth; i=i+1) buyfloat[i] = 32'd0;
			for(i=0; i<ramdepth; i=i+1) sellfloat[i] = 32'd0;
			flag <= 1;
			valid <= 0;
			validD <= 0;
			flag_up <= 0;
			flag_down <= 0;
		end
		else begin
			if(msgtype==16'd0 && side==8'h00 && qty==32'd0) begin 
				flag <= 1;
				valid <= 0;
				flag_up <= 0;
			end
			if(msgtypeD==16'd0) begin
				validD <= 0;
				flag_down <= 0;
			end

			if(msgtypeD==16'h3800 && idvalidD && symbolvalidD && sideD!=8'd0 && qtyD!=32'd0 && flag_down==0)begin
				flag_down <= 1;
				validD <= 1;
				if(symbolerrorD==0 && iderrorD==0)begin
					if(sideD==8'h31)begin
						buyfloat[idindexD*symbolnum+symbolindexD] <= buyfloat[idindexD*symbolnum+symbolindexD] - qtyD;
					end
					if(sideD==8'd32)begin
						sellfloat[idindexD*symbolnum+symbolindexD] <= sellfloat[idindexD*symbolnum+symbolindexD] - qtyD;
					end
				end
			end
			else if(msgtype==16'h4400 && idvalid && symbolvalid && iderror==0 && symbolerror==0 && side!=8'd0 && qty!=32'd0 && flag_up == 0) begin
				flag_up <= 1;
				if(side==8'h31)begin
					if(qty+buyfloat[idindex*symbolnum+symbolindex] > buylimit[idindex*symbolnum+symbolindex]) begin
						flag <= 0;
						valid <= 1;
					end
					else begin
						buyfloat[idindex*symbolnum+symbolindex] <= buyfloat[idindex*symbolnum+symbolindex] + qty;
						flag <= 1;
						valid <= 1;
					end
				end
				if(side==8'h32)begin
					if(qty+sellfloat[idindex*symbolnum+symbolindex] > selllimit[idindex*symbolnum+symbolindex]) begin
						flag <= 0;
						valid <= 1;
					end
					else begin
						sellfloat[idindex*symbolnum+symbolindex] <= sellfloat[idindex*symbolnum+symbolindex] + qty;
						flag <= 1;
						valid <= 1;
					end
				end
			
			end
		end


	end
endmodule
