/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */
#include <stdlib.h>
#include <stdio.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include "usbkeyboard.h"
//#include "usbmouse.h"
struct libusb_device_handle *keyboard;
uint8_t endpoint_address;
int vga_led_fd;

/* Read and print the segment values */
void print_segment_info() {
  vga_led_arg_t vla;
  int i;

  for (i = 0 ; i < 2 ; i++) {
    vla.axis = i;
    if (ioctl(vga_led_fd, VGA_LED_READ_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_READ_DIGIT) failed");
      return;
    }
    printf("%02x ", vla.direction);
  }
  printf("\n");
}

/* Write the contents of the array to the display */
void write_segments(const unsigned int dirs[2])
{
  vga_led_arg_t vla;
  int i;
  for (i = 0 ; i < 2 ; i++) {
    vla.axis = i;
    vla.direction = dirs[i];
    if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
      return;
    }
  }
}


int main()
{
 struct usb_keyboard_packet packet;
  	int transferred;
char keystate[12];
if ( (keyboard = openkeyboard(&endpoint_address)) == NULL ) {
   		fprintf(stderr, "Did not find a keyboard\n");
    		exit(1);
  	}

//int left,leftup,up,leftdown,down,rightdown,right,rightup;
  	int clear_key = 1;



  vga_led_arg_t vla;
  printf("01\n");
  static const char filename[] = "/dev/vga_led";// the driver.c
printf("02\n");
  //initial position of every object and its flag,
   static unsigned int message[6]={0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};
  

  printf("VGA axis Userspace program started\n");

  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  printf("initial state: ");
  print_segment_info();

  write_segments(message);


  printf("current state: ");
  print_segment_info();
  

//control the movement of every object  
  while(1) {
    libusb_interrupt_transfer(keyboard, 0x81,(unsigned char *) &packet, 
			sizeof(packet),&transferred, 10000);
    		 if (transferred == sizeof(packet)) {
printf("endpoint_address %05hx\n", endpoint_address);
printf("transf %d \n", transferred);
      sprintf(keystate, "%02x %02x %02x %02x %02x %02x %02x", packet.modifiers, packet.keycode[0],
	      packet.keycode[1],packet.keycode[2],packet.keycode[3],packet.keycode[4],packet.keycode[5]);
      printf("%s\n", keystate);

     // fbputs(keystate, 6, 0);
  /*
   if (packet.keycode[3]==0x04 && message[1] != 416){  // move downward
     message[1]=3;
     message[2]=1;
     }
   else if (packet.keycode[3]==0x00 && message[1] != 32){ //upward
     message[1]=4;// 4 represent upward :-2
     message[2]=1;
     }  
   else if (packet.keycode[3]==0x06&& message[0] != 64){  //left
     message[0]=2; // 2 represent left :-1
     message[2]=1;
     }
   else if (packet.keycode[3]==0x02 && message[0] != 1024){//right
     message[0]=1;
     message[2]=1;
     }
   else {
     message[2]=0;
     message[0]=0;
     message[1]=0;}
    write_segments(message);
        usleep(10);  
*/
//printf("%x %x %x %x %x %x\n", message[0],message[1],message[2],message[3],message[4],message[5]);
//printf("%x\n", message[1]);
//   printf("%x\n", message[2]);
     // if (packet.keycode[1] == 0x00)/* ESC pressed? */
//	break;


      }

    usleep(10);
  }
  
  printf("VGA LED Userspace program terminating\n");
  return 0;
}

