   module control_ram(en,rst,clk,rd_a_en,wr_a_en,addr_a,center_location);
   input clk,rst,en;
   output reg rd_a_en,wr_a_en;
   output reg [14:0] addr_a;//addr_a is for vga_read and clear,addr_b is for ram_read and write
   output reg [8:0]  center_location;
   
   
   parameter s0=3'b001;
   parameter s1=3'b010;
   parameter s2=3'b111;

   reg [2:0] 	     current_status;
   reg [2:0] 	     next_status;
   reg 		     now_rd;
   reg [8:0] 	     row_scan;
   reg center_mov;	     
    
   always@(posedge clk)//the counter to count addr_a;
      if(rst)
	addr_a<=0;
      else if(addr_a==15'd29999)
	addr_a<=0;
      else if(now_rd==1)
	addr_a<=addr_a+15'd1;
      else
	addr_a<=addr_a;
  
   always@(posedge clk)
     if(rst)
       begin
	  row_scan<=0;
	  center_mov<=0;
       end
     else if(row_scan==299)
       begin
	  row_scan<=0;
	  center_mov<=1;
       end
     else if(now_rd==1)
       begin
	  row_scan<=row_scan+9'd1;
	  center_mov<=0;
       end
     else
       begin
	  row_scan<=row_scan;
	  center_mov<=0;
       end
   
   always@(posedge clk)//give out location
     if(rst)
       center_location<=9'd40;
     else if(center_location==9'd440)
       center_location<=9'd40;
     else if(center_mov)
       center_location<=center_location+1'b1;
     else
       center_location<=center_location;
   
 

   always@(*)
     case(current_status)
       s0:
	 begin
	    rd_a_en=0;
	    now_rd=0;
	    wr_a_en=0;
	 end
       s1:
	 begin
	    rd_a_en=1;
	    wr_a_en=0;
	    now_rd=0;//ori 1
	 end
       s2:
	 begin
	    rd_a_en=0;
	    wr_a_en=1;
	    now_rd=1;
	 end
       default:
	 begin
	    rd_a_en=0;
	    wr_a_en=0;
	    now_rd=0;
	 end
     endcase // case (current_status)
   
   always@(*)
     case(current_status)
       s0:
	 begin
	    if(en)
	      next_status=s1;
	    else
	      next_status=s0;
	 end
       s1:
	 next_status=s2;
       s2:
	 begin
	    if(en)
	      next_status=s1;
	    else
	      next_status=s0;
	 end
       default:
	 next_status=s0;
     endcase // case (current_status)

   always@(posedge clk)
     current_status<=next_status;

 /*  always@*
     if(addr_a==299||599||899||1199||1499||1799||2099||2399||2699||2999||3299||3599||3899||4199||4499||4799||5099||5399||5699||5999||6299||6599||6899||7199||7499||7799||
*/
endmodule // control_ram

       