



module ellipse_draw(
							input logic            clk50,reset,clk25,
							input logic [7:0]      x_in,
							input logic [8:0]      y_in,
							input logic [7:0]      data_rom_f, data_rom_b,data_rom_h,
							input logic [7:0]      data_valid,
							input logic            valid_y_in_buf,
							output logic [13:0]    addr_rom_f, addr_rom_b,
							output logic [12:0]    addr_rom_h,
							output logic [14:0]    addr_win,
							output logic [7:0]     data_win,
							output logic           wren,rden,ready);

	logic [8:0]       y_in_b;
	logic [7:0]       rad;
	logic [7:0]       x_count;
	logic [1:0]       four; //0,1,back 2,3,front
	logic [8:0]       cent_y;
	logic [6:0]       win_y;
	logic [8:0]       win_x;
	logic [7:0]       data_rom_real;
	logic [2:0]       ecc_count;

	parameter win_w=400;
	parameter win_h=70;
	parameter y_in_st=100;



	always @(negedge clk50) 
		begin  
			if (reset)
				begin
					rad<=0;
					y_in_b<=y_in_st;
				end
			else if (valid_y_in_buf&&ready==1)
				begin
					rad <= x_in;
					y_in_b<=y_in;
				end
			else 
				begin
					rad <= rad;
					y_in_b<=y_in_b;
				end
		end //end always

	always_ff @(posedge clk25) 
		begin
			if(reset||(valid_y_in_buf&&ready==1))   
				begin 
					x_count <=0;
					four <=0;
					ecc_count <=0;
					ready<=0;
				end
			else if (ecc_count<3&&x_count<rad&&four<3) 
				begin
					ecc_count<=ecc_count+'d1; 
					x_count<=x_count;
					four<=four;
					ready<=0;
				end
		   else if (ecc_count==3&&x_count<rad&&four<3) 
				begin
					ecc_count<=0;
					x_count<=x_count+1;
					four<=four;
					ready<=0;
				end
		   else if (ecc_count==3&&x_count==rad&&four<3) 
				begin
					ecc_count<='d0;
					x_count<='d0;
					four<=four+'d1;
					ready<=0;
				end
		   else if (ecc_count<3&&x_count==rad&&four<3) 
				begin
					ecc_count<=ecc_count+1;
					x_count<=x_count;
					four<=four ;
					ready<='d0;
				end
		   else if (ecc_count<3&&x_count<rad&&four==3)
				begin
					ecc_count<=ecc_count+'d1; 
					x_count<=x_count;
					four<=four;
					ready<=0;
				end
		   else if (ecc_count==3&&x_count<rad&&four==3) 
				begin
					ecc_count<=0;
					x_count<=x_count+'d1;
					four<=four ;
					ready<='d0;
				end
		   else if (ecc_count<3&&x_count==rad&&four==3) 
				begin
					ecc_count<=ecc_count+1;
					x_count<=x_count;
					four<=four ;
					ready<='d0;
				end
		   else if (ecc_count==3&&x_count==rad&&four==3) 
				begin
					ecc_count<=ecc_count;
					x_count<=x_count;
					four<=four ;
					ready<='d1;
				end
		   else 
				begin
					ecc_count<=ecc_count;
					x_count<=x_count;
					four<=four ;
					ready<=ready;
				end
		end//end always
 

//------------------------- rom address && data ---------------------------
	always@*
		begin
			addr_rom_h =  (2+rad)*(rad-1)/2 + x_count;
			if (four==2'd2)
				addr_rom_f = (rad+1)*(rad-1)+ (rad + x_count[7:0]);
      	else if (four==2'd3)
				addr_rom_f = (rad+1)*(rad-1)+ ( rad - x_count[7:0]);
      	else if (four==2'd0&&y_in_b<=y_in_st+'d12)
				addr_rom_b = (rad+1)*(rad-1)+rad - x_count[7:0];
	   	else if (four==2'd0&&y_in_b>y_in_st+'d12)
				addr_rom_b = (rad+1)*(rad-1)+rad + x_count[7:0];
			else if (four==2'd1&&y_in_b<=y_in_st+'d12)
				addr_rom_b = (rad+1)*(rad-1)+rad + x_count[7:0];
			else if (four==2'd1&&y_in_b>y_in_st+'d12)
				addr_rom_b = (rad+1)*(rad-1)+rad - x_count[7:0];
		end//end always


	always@*
		begin
			if (four==2'd2 || four ==2'd3)
				data_rom_real = data_rom_f;
			else if (four ==2'd0||four==2'd1)
				data_rom_real = data_rom_b;
			else ;
		end //always


//--------------------------frame_buffer address-------------------
	always@*
		begin
			cent_y =(y_in_b-65);
			if (four==2'd2) 
				begin
					win_y = (cent_y + data_rom_h+ecc_count)% win_h;
					win_x = win_w/2 + x_count;
					addr_win = win_y*win_w + win_x;
				end
			else if (four==2'd3) 
				begin
					win_y = (cent_y + data_rom_h+ecc_count)% win_h;
					win_x = win_w/2 - x_count;
					addr_win = win_y*win_w + win_x;
				end
			else if (four==2'd0) 
				begin
					win_y = (cent_y - data_rom_h+ecc_count)% win_h;
					win_x = win_w/2 + x_count;
					addr_win = win_y*win_w + win_x;
				end
			else if (four==2'd1) 
				begin
					win_y = (cent_y - data_rom_h+ecc_count)% win_h;
					win_x = win_w/2 - x_count;
					addr_win = win_y*win_w + win_x;
				end
			else 
				begin
					win_y=win_y;
					win_x=win_x;
					addr_win=addr_win;
				end
	end


	
//-------------------------write data to win-----------------------------------

	always@* 
		begin
			if (clk25==1&&clk50==0)
				begin
					rden=1;
					wren=0;
				end
			else if (y_in_b<100) 
				begin
					rden=0;
					wren=0;
				end
			else if(data_valid==8'd0 && y_in_b>100&&y_in_b<378&& clk25==0&&clk50==0)
				begin 
					data_win = data_rom_real;
					rden = 0;
					wren = 1;
				end
			else if(data_valid==8'd0 && y_in_b==100&& clk25==0&&clk50==0)
				begin
					data_win = data_rom_real+8;
					rden = 0;
					wren = 1;
				end
			else  
				begin
					rden = 0;
					wren = 0;
				end
		end //always



endmodule








    
