module cursor_display(
input clk,reset,
input logic [7:0] delta_x,delta_y,
input logic [10:0] hcount,
input logic [9:0] vcount,
output logic [9:0] cursor_x,cursor_y,
output logic        incursor
);

parameter  cursor_x_st=120;
parameter  cursor_y_st=414;
parameter  cursor_x_end=519;
parameter  cursor_y_end=65;

logic [39:0] counter;

logic       direc_lr; //direc left or right
logic       direc_ud; //direc  up or down
logic       down,up,left,right;
logic [6:0] real_delta_x,real_delta_y;
logic [1:0] dlr_dud;
assign dlr_dud={direc_lr,direc_ud};

assign direc_lr=delta_x[7];
assign direc_ud=delta_y[7];


always@(posedge clk)begin
if(reset)counter<=0;
else if (counter<40'hffffffffff)
counter<=counter+'d1;
else if (counter>=40'hffffffffff)
counter<=0;
end//endalways




always@(posedge counter[19]or posedge reset)begin
if (reset)begin
  cursor_x<=cursor_x_st;
  cursor_y<=cursor_y_st;
end

else begin
  
case (dlr_dud)
2'b00: 
  begin
  down<= (delta_x[6:0]<= delta_y[6:0]);
  right<= (delta_x[6:0]> delta_y[6:0]);
  up<=0;
  left<=0;

  real_delta_x<=delta_x[6:0];
  real_delta_y<=delta_y[6:0];
  if (cursor_x+real_delta_x>=cursor_x_end && cursor_y+real_delta_y>=cursor_y_st )begin
  cursor_x<=cursor_x_end;
  cursor_y<=cursor_y_st;

  end

  else if (cursor_x+real_delta_x>=cursor_x_end && cursor_y+real_delta_y<cursor_y_st )begin
  cursor_x<=cursor_x_end;
  cursor_y<=cursor_y + real_delta_y;
  end

  else if (cursor_x+real_delta_x<cursor_x_end && cursor_y+real_delta_y>=cursor_y_st )begin  
  cursor_x<=cursor_x + real_delta_x;
  cursor_y<=cursor_y_st;
  end

  else  begin 
  cursor_x<=cursor_x + real_delta_x;
  cursor_y<=cursor_y + real_delta_y;
  end

  end//end case00

2'b10:begin
  down<=(delta_x[6:0]<= delta_y[6:0]);
  left<=(delta_x[6:0]> delta_y[6:0]);
  up<=0;
  right<=0;

  real_delta_x<=delta_x[6:0];
  real_delta_y<=delta_y[6:0];
  if (cursor_x-real_delta_x<=cursor_x_st && cursor_y+real_delta_y>=cursor_y_st )begin
  cursor_x<=cursor_x_st;
  cursor_y<=cursor_y_st;

  end

  else if (cursor_x-real_delta_x<=cursor_x_st && cursor_y+real_delta_y<cursor_y_st )begin
  cursor_x<=cursor_x_st;
  cursor_y<=cursor_y_st+real_delta_y;
  end

  else if (cursor_x-real_delta_x>cursor_x_st && cursor_y+real_delta_y<=cursor_y_st )begin  
  cursor_x<=cursor_x - real_delta_x;
  cursor_y<=cursor_y_st;
  end

  else  begin 
  cursor_x<=cursor_x - real_delta_x;
  cursor_y<=cursor_y + real_delta_y;
  end

  end//end case01

2'b01:begin
  up<=(delta_x[6:0]<= delta_y[6:0]);
  right<=(delta_x[6:0]> delta_y[6:0]);
  down<=0;
  left<=0;

  real_delta_x<=delta_x[6:0];
  real_delta_y<=delta_y[6:0];

  if (cursor_x+real_delta_x>=cursor_x_end && cursor_y-real_delta_y<=cursor_y_end )begin
  cursor_x<=cursor_x_end;
  cursor_y<=cursor_y_end;

  end

  else if (cursor_x+real_delta_x>=cursor_x_end && cursor_y-real_delta_y>cursor_y_end )begin
  cursor_x<=cursor_x_end;
  cursor_y<=cursor_y - real_delta_y;
  end

  else if (cursor_x+real_delta_x<cursor_x_end && cursor_y-real_delta_y<=cursor_y_end )begin  
  cursor_x<=cursor_x + real_delta_x;
  cursor_y<=cursor_y_end;
  end

  else  begin 
  cursor_x<=cursor_x + real_delta_x;
  cursor_y<=cursor_y - real_delta_y;
  end

  end//end case10

2'b11:begin
  up<=(delta_x[6:0]<= delta_y[6:0]);
  left<=(delta_x[6:0]> delta_y[6:0]);
  down<=0;
  right<=0;

  real_delta_x<=delta_x[6:0];
  real_delta_y<=delta_y[6:0];

  if (cursor_x-real_delta_x<=cursor_x_st && cursor_y-real_delta_y<=cursor_y_end )begin
  cursor_x<=cursor_x_st;
  cursor_y<=cursor_y_end;

  end

  else if (cursor_x-real_delta_x<=cursor_x_st && cursor_y-real_delta_y>cursor_y_end )begin
  cursor_x<=cursor_x_st;
  cursor_y<=cursor_y - real_delta_y;
  end

  else if (cursor_x-real_delta_x>cursor_x_st && cursor_y-real_delta_y<=cursor_y_end )begin  
  cursor_x<=cursor_x - real_delta_x;
  cursor_y<=cursor_y_end;
  end

  else  begin 
  cursor_x<=cursor_x - real_delta_x;
  cursor_y<=cursor_y - real_delta_y;
  end

end

default: begin
           cursor_x<=cursor_x;
           cursor_y<=cursor_y;
         end

endcase//

end
end//end always

//--------------------------------cursor display---------------------------------------------------

always@* begin
if (up)
 incursor= (hcount[10:1]>=cursor_x-3&&hcount[10:1]<=cursor_x+3&&vcount==cursor_y+1)||(hcount[10:1]>=cursor_x-2 && hcount[10:1]<=cursor_x+2&& vcount==cursor_y)||(hcount[10:1]>=cursor_x-1 && hcount[10:1]<=cursor_x+1&& vcount==cursor_y-1)||(hcount[10:1]==cursor_x&&vcount==cursor_y-2);

else if (down)
 incursor= (hcount[10:1]>=cursor_x-3&&hcount[10:1]<=cursor_x+3&&vcount==cursor_y-1)||(hcount[10:1]>=cursor_x-2 && hcount[10:1]<=cursor_x+2&& vcount==cursor_y)||(hcount[10:1]>=cursor_x-1 && hcount[10:1]<=cursor_x+1&& vcount==cursor_y+1)||(hcount[10:1]==cursor_x&&vcount==cursor_y+2);

else if (left)
 incursor= (vcount>=cursor_y-3 && vcount<=cursor_y+3&& hcount[10:1]==cursor_x-1)||(vcount>=cursor_y-2 && vcount<=cursor_y+2&& hcount[10:1]==cursor_x)||(vcount>=cursor_y-1 && vcount<=cursor_y+1&& hcount[10:1]==cursor_x-1)||(vcount==cursor_y&&hcount[10:1]==cursor_x-2);

else if (right)
 incursor= (vcount>=cursor_y-3 && vcount<=cursor_y+3&& hcount[10:1]==cursor_x+1)||(vcount>=cursor_y-2 && vcount<=cursor_y+2&& hcount[10:1]==cursor_x)||(vcount>=cursor_y-1 && vcount<=cursor_y+1&& hcount[10:1]==cursor_x+1)||(vcount==cursor_y&&hcount[10:1]==cursor_x+2);


else
 incursor=incursor ;

end 

endmodule
//--------------------------------cursor display---------------------------------------------------


/*
always @* begin
   if (hcount[10:1]>=cursor_x-2 && hcount[10:1]<=cursor_x+2 && vcount>= cursor_y && vcount<=cursor_y+2)
       inCursor_up=1;
   else if (hcount[10:1]>=cursor_x-2 && hcount[10:1]<=cursor_x+2 && vcount>= cursor_y-2 && vcount<=cursor_y)
       inCursor_dn=1;
   else if (hcount[10:1]>=cursor_x-2 && hcount[10:1]<=cursor_x && vcount>= cursor_y-2 && vcount<=cursor_y+2)
       inCursor_lf=1;
   else if (hcount[10:1]>=cursor_x && hcount[10:1]<=cursor_x+2 && vcount>= cursor_y-2 && vcount<=cursor_y+2)
       inCursor_rt=1;
end

*/
