/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
					input logic 	  reset,
					input logic [7:0]  writedata,
					input logic 	  write,
					input 		  chipselect,
					input logic [5:0]  address,

					output logic [7:0] VGA_R, VGA_G, VGA_B,
					output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
					output logic 	  VGA_SYNC_n);

	 
   reg [7:0] 	hex0, hex1, hex2, hex3, hex4, hex5, hex6, hex7, hex8, hex9,
					hex10, hex11, hex12, hex13, hex14, hex15, hex16, hex17, hex18, hex19,
					hex20, hex21, hex22, hex23, hex24, hex25, hex26, hex27, hex28, hex29,
					hex30, hex31, hex32, hex33, hex34, hex35, hex36, hex37, hex38, hex39,
					hex40, hex41, hex42, hex43, hex44, hex45, hex46, hex47, hex48, hex49,
					hex50, hex51, hex52, hex53, hex54, hex55, hex56, hex57, hex58, hex59;

   VGA_LED_Emulator led_emulator(.clk50(clk), .*);
	


   always_ff @(posedge clk)
     if (reset) begin
	hex0 <= 8'd0; 
	hex1 <= 8'd0; 
	hex2 <= 8'd0; 
	hex3 <= 8'd0; 
	hex4 <= 8'd0; 
	hex5 <= 8'd0; 
	hex6 <= 8'd0; 
	hex7 <= 8'd0;
	hex8 <= 8'd0; 
	hex9 <= 8'd0; 
	hex10 <= 8'd0; 
	hex11 <= 8'd0; 
	hex12 <= 8'd0; 
	hex13 <= 8'd0; 
	hex14 <= 8'd0; 
	hex15 <= 8'd0; 
	hex16 <= 8'd0; 
	hex17 <= 8'd0;
	hex18 <= 8'd0; 
	hex19 <= 8'd0;  
	hex20 <= 8'd0; 
	hex21 <= 8'd0; 
	hex22 <= 8'd0; 
	hex23 <= 8'd0; 
	hex24 <= 8'd0; 
	hex25 <= 8'd0; 
	hex26 <= 8'd0; 
	hex27 <= 8'd0;
	hex28 <= 8'd0; 
	hex29 <= 8'd0; 
	hex30 <= 8'd0; 
	hex31 <= 8'd0; 
	hex32 <= 8'd0; 
	hex33 <= 8'd0; 	
	hex34 <= 8'd206; 
	hex35 <= 8'd20; 
	hex36 <= 8'd236; 
	hex37 <= 8'd246;
	hex38 <= 8'd0; 
	hex39 <= 8'd10;	
	hex40 <= 8'd0;
	hex41 <= 8'd0; 
	hex42 <= 8'd0; 
	hex43 <= 8'd0; 
	hex44 <= 8'd0; 
	hex45 <= 8'd0; 
	hex46 <= 8'd0; 
	hex47 <= 8'd0;
	hex48 <= 8'd0; 
	hex49 <= 8'd0; 
	hex50 <= 8'd0;
	hex51 <= 8'd0; 
	hex52 <= 8'd0; 
	hex53 <= 8'd0; 
	hex54 <= 8'd0; 
	hex55 <= 8'd0; 
	hex56 <= 8'd0; 
	hex57 <= 8'd0;
	hex58 <= 8'd0; 
	hex59 <= 8'd0; 
	
     end else if (chipselect && write)
       case (address)
	 6'd0 : hex0 <= writedata;
	 6'd1 : hex1 <= writedata;
	 6'd2 : hex2 <= writedata;
	 6'd3 : hex3 <= writedata;
	 6'd4 : hex4 <= writedata;
	 6'd5 : hex5 <= writedata;
	 6'd6 : hex6 <= writedata;
	 6'd7 : hex7 <= writedata;
	 6'd8 : hex8 <= writedata;
	 6'd9 : hex9 <= writedata;
	 6'd10 : hex10 <= writedata;
	 6'd11 : hex11 <= writedata;
	 6'd12 : hex12 <= writedata;
	 6'd13 : hex13 <= writedata;
	 6'd14 : hex14 <= writedata;
	 6'd15 : hex15 <= writedata;
	 6'd16 : hex16 <= writedata;
	 6'd17 : hex17 <= writedata;
	 6'd18 : hex18 <= writedata;
	 6'd19 : hex19 <= writedata;
	 6'd20 : hex20 <= writedata;
	 6'd21 : hex21 <= writedata;
	 6'd22 : hex22 <= writedata;
	 6'd23 : hex23 <= writedata;
	 6'd24 : hex24 <= writedata;
	 6'd25 : hex25 <= writedata;
	 6'd26 : hex26 <= writedata;
	 6'd27 : hex27 <= writedata;
	 6'd28 : hex28 <= writedata;
	 6'd29 : hex29 <= writedata;
	 6'd30 : hex30 <= writedata;
	 6'd31 : hex31 <= writedata;
	 6'd32 : hex32 <= writedata;
	 6'd33 : hex33 <= writedata;
	 6'd34 : hex34 <= writedata;
	 6'd35 : hex35 <= writedata;
	 6'd36 : hex36 <= writedata;
	 6'd37 : hex37 <= writedata;
	 6'd38 : hex38 <= writedata;
	 6'd39 : hex39 <= writedata;	 
	 6'd40 : hex40 <= writedata;
	 6'd41 : hex41 <= writedata;
	 6'd42 : hex42 <= writedata;
	 6'd43 : hex43 <= writedata;
	 6'd44 : hex44 <= writedata;
	 6'd45 : hex45 <= writedata;
	 6'd46 : hex46 <= writedata;
	 6'd47 : hex47 <= writedata;
	 6'd48 : hex48 <= writedata;
	 6'd49 : hex49 <= writedata;
	 6'd50 : hex50 <= writedata;
	 6'd51 : hex51 <= writedata;
	 6'd52 : hex52 <= writedata;
	 6'd53 : hex53 <= writedata;
	 6'd54 : hex54 <= writedata;
	 6'd55 : hex55 <= writedata;
	 6'd56 : hex56 <= writedata;
	 6'd57 : hex57 <= writedata;
	 6'd58 : hex58 <= writedata;
	 6'd59 : hex59 <= writedata;
       endcase
	       
endmodule
