/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [7:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [2:0]  address,

	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n);

	 
   logic [7:0] 			  hex0, hex1, hex2, hex3,
				  hex4, hex5, hex6, hex7;

   VGA_LED_Emulator led_emulator(.clk50(clk), .*);
	assign {hex1,hex0} = 724;
	assign {hex3,hex2} = 724;
	assign {hex5,hex4} = 724;
	assign {hex7,hex6} = 724;
//	sin_x sinx(.address({2'b0,writedata}), .clock(clk), .q({hex1,hex0}));
//	cos_x cosx(.address({2'b0,writedata}), .clock(clk), .q({hex3,hex2}));
//	sin_y siny(.address({2'b0,writedata}), .clock(clk), .q({hex5,hex4}));
//	cos_y cosy(.address({2'b0,writedata}), .clock(clk), .q({hex7,hex6}));

//   always_ff @(posedge clk)
//     if (reset) begin
//	hex0 <= 8'b00000000; // 4
//	hex1 <= 8'b00000001; // 8
//	hex2 <= 8'b00000000; // 4
//	hex3 <= 8'b00000001; // 0
//	hex4 <= 8'b00111111; // L
//	hex5 <= 8'b00111111; // A
//	hex6 <= 8'b00111111; // b
//	hex7 <= 8'b00111111; // 3
//     end else if (chipselect && write)
//       case (address)
//	 3'h0 : hex0 <= writedata;
//	 3'h1 : hex1 <= writedata;
//	 3'h2 : hex2 <= writedata;
//	 3'h3 : hex3 <= writedata;
//	 3'h4 : hex4 <= writedata;
//	 3'h5 : hex5 <= writedata;
//	 3'h6 : hex6 <= writedata;
//	 3'h7 : hex7 <= writedata;
//       endcase
	       
endmodule
