#ifndef _ULTRASONIC_H
#define _ULTRASONIC_H

#include <linux/ioctl.h>
//for __u32
#include <linux/types.h> 

//F:front, R:right, B:back
//e.g. FR: us on the right corner in the front
//e.g. RF: us in the front of right side
/* Note: If gona to change position or number of sensors,
 * modify the following places:
 * 1. HW part, of course
 * 2. dts file
 * 3. SW:
 *    (a) in this file (.h), change NUM_OF_US and enum
		  (make sure the order are exactly the same as it in HW. 
		   For example, if addr 0,1,2,3 in HW are FR,RF,RB,BR respectively, 
		   then here should be enum {FR,RF,RB,BR} as well. Don't try to 
           assign the enum num, since I use its default values, from 0 to
		   NUM_OF_US-1
 *    (b) in .c file, nothing needs to be changed.
 */
#define NUM_OF_US 4
typedef enum {FR,RF,RB,BR} us_position_t;


typedef struct {
  us_position_t pos; 
  __u32 distance;
} ultrasonic_t;


#define ULTRASONIC_MAGIC 'u'

/* ioctls and their arguments */
#define ULTRASONIC_GET_DIST_WITH_POS _IOWR(ULTRASONIC_MAGIC, 1, ultrasonic_t) //no ; , be careful


#endif
