#ifndef _S_MOTOR_H
#define _S_MOTOR_H

#include <linux/ioctl.h>
//for __u32
#include <linux/types.h> 

#define MIN_ANGLE_LV 0
#define MAX_ANGLE_LV 7

typedef enum {RIGHT, LEFT} s_direction_t;


typedef struct {
  s_direction_t s_dir; 
  __u32 angle; 
} s_motor_t;


#define S_MOTOR_MAGIC 's'

/* ioctls and their arguments */
#define S_MOTOR_SET_DIR _IOW(S_MOTOR_MAGIC, 1, s_direction_t) //no ; , be careful
#define S_MOTOR_SET_ANGLE _IOW(S_MOTOR_MAGIC, 2, __u32)
#define S_MOTOR_GET_DIR _IOR(S_MOTOR_MAGIC, 3, s_direction_t)
#define S_MOTOR_GET_ANGLE _IOR(S_MOTOR_MAGIC, 4, __u32)

#endif
