#ifndef _R_MOTOR_H
#define _R_MOTOR_H

#include <linux/ioctl.h>
//for __u32
#include <linux/types.h> 

#define MIN_SPEED_LV 0
#define MAX_SPEED_LV 8

typedef enum {FORWARD, BACKWARD} r_direction_t;


typedef struct {
  r_direction_t r_dir; 
  __u32 speed; 
} r_motor_t;


#define R_MOTOR_MAGIC 'r'

/* ioctls and their arguments */
#define R_MOTOR_SET_DIR _IOW(R_MOTOR_MAGIC, 1, r_direction_t) //no ; , be careful
#define R_MOTOR_SET_SPEED _IOW(R_MOTOR_MAGIC, 2, __u32)
#define R_MOTOR_GET_DIR _IOR(R_MOTOR_MAGIC, 3, r_direction_t)
#define R_MOTOR_GET_SPEED _IOR(R_MOTOR_MAGIC, 4, __u32)

#endif
