#ifndef _PARKING_ROBOT_PARAMETERS_H
#define _PARKING_ROBOT_PARAMETERS_H


//===================== COMMON =====================
#ifndef TRUE
	#define TRUE (1==1)
#endif

#ifndef FALSE
	#define FALSE (1==0)
#endif

//define the perioid between two ultrasonics' values fetch. 
//since we have four us, and each of them needs at least
//60ms (we use 65ms), therefore a value of any of them
//wont't change at least for 65ms * 4
#define ULTRASONICS_READ_INTERVAL 260000
#define STEERING_WAIT_TIME 1000000
#define US_RF_OFFSET 2100

#define CAR_LENGTH 34.0		
#define CAR_WIDTH 24.0
#define CAR_LENGTH_WIDTH_SAFE_MARGIN 0

//===================== AUTO PARKING THREAD =====================
#define PARALLEL_ENOUGH_COUNT 27
#define GARAGE_ENOUGH_COUNT 10


//===================== PARALELL PARKING =====================

#define RADIUS 48.25
#define TURN_SPEED 8.29
#define STRAIGHT_SPEED 7.4
#define RIGHT_MARGIN 5.0
#define FRONT_MARGIN 5.0
#define ULTRA_POSITION 5.0


//===================== GARAGE PARKING =====================

//===================== MISC =====================
#define SEPERATE_BAR_1 "==================================="
#define SEPERATE_BAR_2 "-----------------------------------"


#endif
