/*
 * Parking Robot Team
 * Columbia University
 */


#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#include "parameters.h"
#include "driver_functions.h"
#include "independent_parking.h"



void parallel_parking_independent()
{
  

 // Auto parking parameter

int state, adjust, counter;
float angleToTurn;
float parkPitch;
float distanceToMove;
float lotWidth,lotLength;
float CURF, CURB, CUBR, CUFR, CURF_MAX, CURB_MAX; 
float turnPosition;

 printf("Parallel parking started\n");


 // Initializing parameter 

  state = 0;
  CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  CURB = cycles_to_cm(read_ultrasonic_distance(RB));
  
  // The distance between the car and the wall
  parkPitch = ( CURF + CURB )/ 2 ;
  
  
  write_r_motor_dir(FORWARD);  
  write_r_motor_speed(0);
  
  write_s_motor_dir(RIGHT);  
  write_s_motor_angle(0);

	lotWidth = 0;
	CURF_MAX = 0;
	CURB_MAX = 0;


			
// Start parallel parking
  
  while(TRUE) {


	if (state == 0){


	// Go forward with speed level "1"
	write_r_motor_dir(FORWARD);
	write_r_motor_speed(1);  
	
	// Set servo motor angle to zero, meaning to go straight.
    write_s_motor_dir(RIGHT);  
    write_s_motor_angle(0);
    // CURF = Current Ultrasonic Value for rightside - front ultrasonic
	CURF = cycles_to_cm(read_ultrasonic_distance(RF));
		if (CURF > parkPitch + 10){ 
		// If CURF gets larger than parkpitch, meaning that parking lot hase been detected, then go to the next state
		state = 1;		
		}

	}
	if (state == 1){
	
	write_r_motor_dir(FORWARD);
	write_r_motor_speed(1);  
	
    write_s_motor_dir(RIGHT);  
    write_s_motor_angle(0);
	CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  	CURB = cycles_to_cm(read_ultrasonic_distance(RB));

  	// Find the maximum distance detected to calculate the width of the parking lot
	if (CURF > CURF_MAX){
	CURF_MAX = CURF;	
	}
	if (CURB > CURB_MAX){
	CURB_MAX = CURB;	
	}
	// Width of parking lot = maximum distance detected (average for two rightside ultrasonic) - parkPitch
	lotWidth = (CURF_MAX+CURB_MAX)/2 - parkPitch;
			usleep(200000);
		// If CURF and CURB get closer to parkPitch, then the car has reach the end of the parking lot
		if (abs(parkPitch - CURF) < 30 && abs(parkPitch - CURB) < 30 ){
		state = 2;		
		}	
	}
	if (state == 2){
	CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  	CURB = cycles_to_cm(read_ultrasonic_distance(RB));

  	// Calculate parkPitch again to calibrate, because the car may deviate during previous state.
	parkPitch = ( CURF + CURB )/ 2 ;
	
	
	write_r_motor_dir(FORWARD);
	write_r_motor_speed(0);  
	
    write_s_motor_dir(RIGHT);  
    write_s_motor_angle(0);

	// Auto parking start here
	
	// Calculate angle and distance for parking

	angleToTurn = acos((RADIUS - 0.5*( CAR_WIDTH/2 + parkPitch + RADIUS + lotWidth - RIGHT_MARGIN - sqrt((RADIUS + CAR_WIDTH/2)*(RADIUS + CAR_WIDTH/2) +(CAR_LENGTH/2)*(CAR_LENGTH/2))) )/RADIUS);

    distanceToMove = - CAR_LENGTH/2 + sqrt((RADIUS - CAR_WIDTH/2)*(RADIUS - CAR_WIDTH/2) - (RADIUS -CAR_WIDTH/2 -parkPitch)*(RADIUS -CAR_WIDTH/2 -parkPitch) ) -5 ;
	

	turnPosition = (0.5*CAR_WIDTH + 0.5*( lotWidth + parkPitch) + 0.5*(sqrt((RADIUS + 0.5*CAR_WIDTH)*(RADIUS + 0.5*CAR_WIDTH) + (0.5*CAR_LENGTH)*(0.5*CAR_LENGTH)) - (RADIUS + 0.5*CAR_WIDTH)))/(sin(angleToTurn)) - 0.5*CAR_LENGTH - ULTRA_POSITION/(tan(angleToTurn));
	

			
			
			if (distanceToMove >= 0 ){
				write_r_motor_dir(FORWARD);
			
			}
			else{
				write_r_motor_dir(BACKWARD);
			
			}

			// Go with speed level 1
			write_r_motor_speed(1); 
			usleep(STEERING_WAIT_TIME *(int)(distanceToMove/STRAIGHT_SPEED));

			// Stop
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0);

			// Turn the wheels to the right max
			
			write_s_motor_dir(RIGHT);  
			write_s_motor_angle(7);
			usleep(STEERING_WAIT_TIME);

			// Moving backward toward the parking lot
			
			write_r_motor_dir(BACKWARD);
			write_r_motor_speed(1);
			CUBR =  cycles_to_cm(read_ultrasonic_distance(BR));
			while(CUBR > 20){
				usleep(ULTRASONICS_READ_INTERVAL);	
				CUBR =  cycles_to_cm(read_ultrasonic_distance(BR));	
			}
			
			write_r_motor_dir(FORWARD);
			while(CUBR < turnPosition - 5 ){
				usleep(ULTRASONICS_READ_INTERVAL);  
				CUBR = cycles_to_cm(read_ultrasonic_distance(BR));
			}
			

			//stop
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0); 
			
			//to turn the wheels to the left max
			write_s_motor_dir(LEFT);  
			write_s_motor_angle(7);
			usleep(STEERING_WAIT_TIME);
			
			write_r_motor_dir(BACKWARD);
			write_r_motor_speed(1);
			CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  			CURB = cycles_to_cm(read_ultrasonic_distance(RB));
  			// adjust is a state for adjusting the car position while the car is moving through the second arc.
  			// For adjust = 0, the car is now moving backward and turning left.
  			// For adjust = 1, the car is moving forward and turning right.
  			// In each one states, the car will try to park parallel with the wall (CURF == CURB)
  			// But if there is a near obstacle, it will jump to another state and try to keep park parallel.

			adjust = 0;

			// This counter is for checking CURF == CURB, the equal is recognize only when it has been detected twice.
			counter = 0;
			while(abs(CURF - CURB) >= 4 || (counter < 2) ){
				if (abs(CURF - CURB) >= 2){
					counter = 0;
				}
				while (adjust == 0){
	
					CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  					CURB = cycles_to_cm(read_ultrasonic_distance(RB));
					CUBR = cycles_to_cm(read_ultrasonic_distance(BR));

					// abs(CURF - CURB) < 2 means they are equal. But we want them to be less than 30,
					// to make sure we did't measure the distance from an irrelevent, far away place. 
					if ( abs(CURF - CURB) < 2 && CURF < 30 && CURB < 30){
						counter ++;
						usleep(ULTRASONICS_READ_INTERVAL);
						break;
					}
					else {
						// if the obstacle is too close, switch to another adjust
						if ( CUBR < 15){
							//stop
							write_r_motor_dir(FORWARD);
							write_r_motor_speed(0);
							//to turn the wheels to the right max
					    	write_s_motor_dir(RIGHT);  
					    	write_s_motor_angle(7);
							usleep(STEERING_WAIT_TIME);
							//forward right
							write_r_motor_dir(FORWARD);
							write_r_motor_speed(1);
							adjust = 1;
							counter = 0;	
						}
						else{
							usleep(ULTRASONICS_READ_INTERVAL);
						}
					}
				}
				while (adjust == 1){
					CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  					CURB = cycles_to_cm(read_ultrasonic_distance(RB));
					CUFR = cycles_to_cm(read_ultrasonic_distance(FR));
					if ( abs(CURF - CURB) < 2 && CURF < 30 && CURB < 30 ){
						counter ++;
						usleep(ULTRASONICS_READ_INTERVAL);
						break;
					}
					else {
						if ( CUFR < 15){
							//stop
							write_r_motor_dir(FORWARD);
							write_r_motor_speed(0); 
							//to turn the wheels to the left max
					    	write_s_motor_dir(LEFT);  
					    	write_s_motor_angle(7);
							usleep(STEERING_WAIT_TIME);
							//backward left
							write_r_motor_dir(BACKWARD);
							write_r_motor_speed(1);
							adjust = 0;
							counter = 0;
							}
						else{
							usleep(ULTRASONICS_READ_INTERVAL);
							}
					}
				}
			}
			//Stop the steering motor and go to state 3 
			//
		    write_s_motor_dir(LEFT);  
		    write_s_motor_angle(0);
		    state=3;

			}
	if(state==3){
			// Stop the car and finish the parking
			//stop the regular motor
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0);
			//to stop the steering motor
		    write_s_motor_dir(LEFT);  
		    write_s_motor_angle(0);
		    printf("Parallel parking finished\n");
		    		    
			return;


	}
    }

}	

