/*
 * Parking Robot Team
 * Columbia University
 */


#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#include "parameters.h"
#include "driver_functions.h"
#include "parallel_parking.h"

void parallel_parking(float parkPitch, float lotWidth){

	int state, adjust;
	float angleToTurn;
	//float parkPitch;
	float distanceToMove;
	float phi_in,phi_out,rin_p, phi_p,rout_p,out;
	//float a,b,c,A,angle_p,angle_n;
	//float speed;
	float CURF, CURB, CUBR, CUFR;
	float turnPosition;
	int counter;

	

	printf("Parallel parking started\n");

		
	//Initialize
	state = 2;
	CURF = cycles_to_cm(read_ultrasonic_distance(RF));
	CURB = cycles_to_cm(read_ultrasonic_distance(RB));
	//parkPitch = ( CURF + CURB )/ 2 ;
	//lotWidth = 0;
	
	write_r_motor_dir(FORWARD);  
	write_r_motor_speed(0);
	write_s_motor_dir(RIGHT);  
	write_s_motor_angle(0);

	
	while(TRUE) {


		

		if (state == 2){
			CURF = cycles_to_cm(read_ultrasonic_distance(RF));
		  	CURB = cycles_to_cm(read_ultrasonic_distance(RB));
			//parkPitch = ( CURF + CURB )/ 2 ;
			
			
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0);  
			
		    write_s_motor_dir(RIGHT);  
		    write_s_motor_angle(0);

			// Auto parking start here
			printf("parkPitch = %f\n", parkPitch);
			printf("lotWidth = %f\n", lotWidth);
			
			
			angleToTurn = acos((RADIUS - 0.5*( CAR_WIDTH/2 + parkPitch + RADIUS + lotWidth - RIGHT_MARGIN - sqrt((RADIUS + CAR_WIDTH/2)*(RADIUS + CAR_WIDTH/2) +(CAR_LENGTH/2)*(CAR_LENGTH/2))) )/RADIUS);

		    distanceToMove = - CAR_LENGTH/2 + sqrt((RADIUS - CAR_WIDTH/2)*(RADIUS - CAR_WIDTH/2) - (RADIUS -CAR_WIDTH/2 -parkPitch)*(RADIUS -CAR_WIDTH/2 -parkPitch) ) ;
			

			turnPosition = (0.5*CAR_WIDTH + 0.5*( lotWidth + parkPitch) + 0.5*(sqrt((RADIUS + 0.5*CAR_WIDTH)*(RADIUS + 0.5*CAR_WIDTH) + (0.5*CAR_LENGTH)*(0.5*CAR_LENGTH)) - (RADIUS + 0.5*CAR_WIDTH)))/(sin(angleToTurn)) - 0.5*CAR_LENGTH - ULTRA_POSITION/(tan(angleToTurn));
			
			printf("angleToTurn = %f\n", angleToTurn );

			printf("turnPosition = %f\n", turnPosition );
			printf(" Y  = %f\n", (0.5*CAR_WIDTH + 0.5*( lotWidth + parkPitch) + 0.5*(sqrt((RADIUS + 0.5*CAR_WIDTH)*(RADIUS + 0.5*CAR_WIDTH) + (0.5*CAR_LENGTH)*(0.5*CAR_LENGTH)) - (RADIUS + 0.5*CAR_WIDTH))));
			
			printf("distance to move = %f\n",distanceToMove);
			
			
			if (distanceToMove >= 0 ){
				write_r_motor_dir(FORWARD);
			
			}
			else{
				write_r_motor_dir(BACKWARD);
			
			}
			write_r_motor_speed(1); 
			usleep(STEERING_WAIT_TIME *(int)(distanceToMove/STRAIGHT_SPEED));// go forward
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0);//stop 
			
			write_s_motor_dir(RIGHT);  
			write_s_motor_angle(7);//to turn the wheels to the right max
			usleep(STEERING_WAIT_TIME);
			
			write_r_motor_dir(BACKWARD);
			write_r_motor_speed(1);
			CUBR =  cycles_to_cm(read_ultrasonic_distance(BR));
			while(CUBR > 20){
				usleep(ULTRASONICS_READ_INTERVAL);	
				CUBR =  cycles_to_cm(read_ultrasonic_distance(BR));	
			}
			
			write_r_motor_dir(FORWARD);
			while(CUBR < turnPosition - 5 ){
				usleep(ULTRASONICS_READ_INTERVAL);  
				CUBR = cycles_to_cm(read_ultrasonic_distance(BR));
				//printf("CUBR = %f\n",CUBR);
			}
			
			//usleep(STEERING_WAIT_TIME* (int)(abs(angleToTurn*RADIUS/TURN_SPEED)));// to go backward
			
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0);//stop 
			
			write_s_motor_dir(LEFT);  
			write_s_motor_angle(7);//to turn the wheels to the left max
			usleep(STEERING_WAIT_TIME);
			
			write_r_motor_dir(BACKWARD);
			write_r_motor_speed(1);
			CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  			CURB = cycles_to_cm(read_ultrasonic_distance(RB));
			printf("adjust preread CURF = %f, CURB = %f\n", CURF,CURB);
			adjust = 0;
			counter = 0;
			while(abs(CURF - CURB) >= 4 || (counter < 2) /* can set by user*/){
				printf("adjust W1 CURF = %f, CURB = %f\n", CURF,CURB);
				if (abs(CURF - CURB) >= 2){
					counter = 0;
				}
				while (adjust == 0){
	
					CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  					CURB = cycles_to_cm(read_ultrasonic_distance(RB));
					CUBR = cycles_to_cm(read_ultrasonic_distance(BR));
					printf("adjust W2 adjust0 CURF = %f, CURB = %f\n", CURF,CURB);
					if ( abs(CURF - CURB) < 1 && CURF < 30 && CURB < 30/* can set by user*/){
						counter ++;
						printf("counter = %d\n",counter);
						usleep(ULTRASONICS_READ_INTERVAL);
						break;
					}
					else {
						if ( CUBR < 15/* can set by user*/){
							
							write_r_motor_dir(FORWARD);
							write_r_motor_speed(0);//stop 
							
					    	write_s_motor_dir(RIGHT);  
					    	write_s_motor_angle(7);
							usleep(STEERING_WAIT_TIME);//to turn the wheels to the right max
							
							write_r_motor_dir(FORWARD);
							write_r_motor_speed(1);//forward right
							adjust = 1;
							counter = 0;	
							printf("counter reset\n");
						}
						else{
							usleep(ULTRASONICS_READ_INTERVAL);
							printf("break 0.26s\n");
						}
					}
				}
				while (adjust == 1){
					CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  					CURB = cycles_to_cm(read_ultrasonic_distance(RB));
					CUFR = cycles_to_cm(read_ultrasonic_distance(FR));
					printf("adjust W2 adjust1 CURF = %f, CURB = %f\n", CURF,CURB);
					if ( abs(CURF - CURB) < 1 && CURF < 30 && CURB < 30 /* can set by user*/){
						counter ++;
						printf("counter = %d\n",counter);
						usleep(ULTRASONICS_READ_INTERVAL);
						break;
					}
					else {
						if ( CUFR < 12/* can set by user*/){
							
							write_r_motor_dir(FORWARD);
							write_r_motor_speed(0);//stop 
							
					    	write_s_motor_dir(LEFT);  
					    	write_s_motor_angle(7);
							usleep(STEERING_WAIT_TIME);//to turn the wheels to the right max
							
							write_r_motor_dir(BACKWARD);
							write_r_motor_speed(1);//backward left
							adjust = 0;
							counter = 0;
							printf("counter reset");	
						}
						else{
							usleep(ULTRASONICS_READ_INTERVAL);
							printf("break 0.26s\n");
						}
					}
				}
			}
			//usleep(STEERING_WAIT_TIME *(int)(abs(angleToTurn*RADIUS/TURN_SPEED)));
			
		    write_s_motor_dir(LEFT);  
		    write_s_motor_angle(0);//to stop the steering motor
		    state=3;

			}
	if(state==3){
			
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0);//stop the regular motor
			
		    write_s_motor_dir(LEFT);  
		    write_s_motor_angle(0);//to stop the steering motor
		    printf("Parallel parking finished\n");
		    //pthread_join(data_collector_thread, NULL);		    
			return;


	}
	}

}	
