/*
 * Parking Robot Team
 */

 /* This is a automatic garage parking system, it is very similar to parallel_parking_independent .c
	Their code are the same as parallel_parking_independent.c until Ln 150
 */


#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

#include "parameters.h"
#include "driver_functions.h"
#include "independent_parking.h"




void garage_parking()
{
  
  
  
 // Auto parking parameter
int state, adjust;
float angleToTurn;
float parkPitch;
float distanceToMove;
float lotWidth,lotLength;
float CURF, CURB, CUBR, CUFR, CURF_MAX, CURB_MAX;
float turnPosition;


printf("Garage parking started\n");

  
			
			
// Initializing, please refer to parallel_parking_independent.c
  
  state = 0;
  CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  CURB = cycles_to_cm(read_ultrasonic_distance(RB));
  parkPitch = ( CURF + CURB )/ 2 ;
  
  
  write_r_motor_dir(FORWARD);  
  write_r_motor_speed(0);
  
  write_s_motor_dir(RIGHT);  
  write_s_motor_angle(0);

	lotWidth = 0;
	CURF_MAX = 0;
	CURB_MAX = 0;


// garage parking starts			


  while(TRUE) {


	if (state == 0){
	
	write_r_motor_dir(FORWARD);
	write_r_motor_speed(1);  
	
    write_s_motor_dir(RIGHT);  
    write_s_motor_angle(0);
	CURF = cycles_to_cm(read_ultrasonic_distance(RF));
		if (CURF > parkPitch + CAR_WIDTH + 10){
		state = 1;		
		}

	}
	if (state == 1){
	
	write_r_motor_dir(FORWARD);
	write_r_motor_speed(1);  
	
    write_s_motor_dir(RIGHT);  
    write_s_motor_angle(0);
	CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  	CURB = cycles_to_cm(read_ultrasonic_distance(RB));
	if (CURF > CURF_MAX){
	CURF_MAX = CURF;	
	}
	if (CURB > CURB_MAX){
	CURB_MAX = CURB;	
	}

	lotWidth = (CURF_MAX+CURB_MAX)/2 - parkPitch;
			usleep(200000);
		if (abs(parkPitch - CURF) < 30 && abs(parkPitch - CURB) < 30 ){
		state = 2;		
		}	
	}
	if (state == 2){
	CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  	CURB = cycles_to_cm(read_ultrasonic_distance(RB));
	parkPitch = ( CURF + CURB )/ 2 ;
	
	
	write_r_motor_dir(FORWARD);
	write_r_motor_speed(0);  
	
    write_s_motor_dir(RIGHT);  
    write_s_motor_angle(0);
	
	angleToTurn = acos((RADIUS - 0.5*( CAR_WIDTH/2 + parkPitch + RADIUS + lotWidth - RIGHT_MARGIN - sqrt((RADIUS + CAR_WIDTH/2)*(RADIUS + CAR_WIDTH/2) +(CAR_LENGTH/2)*(CAR_LENGTH/2))) )/RADIUS);

    distanceToMove = - CAR_LENGTH/2 + sqrt((RADIUS - CAR_WIDTH/2)*(RADIUS - CAR_WIDTH/2) - (RADIUS -CAR_WIDTH/2 -parkPitch)*(RADIUS -CAR_WIDTH/2 -parkPitch) ) - 5 ;
	

	turnPosition = (0.5*CAR_WIDTH + 0.5*( lotWidth + parkPitch) + 0.5*(sqrt((RADIUS + 0.5*CAR_WIDTH)*(RADIUS + 0.5*CAR_WIDTH) + (0.5*CAR_LENGTH)*(0.5*CAR_LENGTH)) - (RADIUS + 0.5*CAR_WIDTH)))/(sin(angleToTurn)) - 0.5*CAR_LENGTH - ULTRA_POSITION/(tan(angleToTurn));
			
			if (distanceToMove >=0){
				write_r_motor_dir(FORWARD);
			}
			else{
				write_r_motor_dir(BACKWARD);
			}
			write_r_motor_speed(1); 
			usleep(STEERING_WAIT_TIME *(int)(distanceToMove/STRAIGHT_SPEED));
			
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0); 
			
	        	write_s_motor_dir(RIGHT);  
	        	write_s_motor_angle(7);
			usleep(STEERING_WAIT_TIME);
			
			write_r_motor_dir(BACKWARD);
			write_r_motor_speed(1);
			
			CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  			CURB = cycles_to_cm(read_ultrasonic_distance(RB));

			while(abs(CURF - CURB) < 10){
				usleep(ULTRASONICS_READ_INTERVAL);
				CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  				CURB = cycles_to_cm(read_ultrasonic_distance(RB));
				CUBR = cycles_to_cm(read_ultrasonic_distance(BR));		
			} 

			// Try to pull the car straight, unless reach the end of the parking lot
			while(abs(CURF - CURB) > 2){
			
				CUBR = cycles_to_cm(read_ultrasonic_distance(BR));
				if (CUBR < 7){
					printf("Parking completed at stage 2, the car may not be completely straight, CUBR = %f", CUBR);		
				break;		
				}					
				usleep(ULTRASONICS_READ_INTERVAL);
				CURF = cycles_to_cm(read_ultrasonic_distance(RF));
  				CURB = cycles_to_cm(read_ultrasonic_distance(RB));
			}
			while(CUBR > 15){
				CUBR = cycles_to_cm(read_ultrasonic_distance(BR));
				usleep(ULTRASONICS_READ_INTERVAL);
				
			}
			
		    write_s_motor_dir(LEFT);  
		    write_s_motor_angle(0);
			state=3;
				

			
	}
	if(state==3){
			
			write_r_motor_dir(FORWARD);
			write_r_motor_speed(0);
			
		    write_s_motor_dir(LEFT);  
		    write_s_motor_angle(0);
		    printf("Garage parking finished\n");
				    
			return;


	}
	
  }

}	

