#ifndef _PARKING_ROBOT_DRIVER_FUNCTIONS_H
#define _PARKING_ROBOT_DRIVER_FUNCTIONS_H

#include "regular_motor.h"
#include "steering_motor.h"
#include "ultrasonic_sensor.h"

#include <sys/types.h>



//get driver resources, return boolean value
char open_drivers();


//==== regular motor ====
void write_r_motor_dir(const r_direction_t r_dir);
void write_r_motor_speed(const __u32 speed);
r_direction_t read_r_motor_dir();
__u32 read_r_motor_speed();

//==== steering motor ====
void write_s_motor_dir(const s_direction_t s_dir);
void write_s_motor_angle(const __u32 angle);
s_direction_t read_s_motor_dir();
__u32 read_s_motor_angle();

//==== ultrasonic sensor =====
__u32 read_ultrasonic_distance(us_position_t pos);
//conver cycles from read_ultrasonic_distance to cm value
float cycles_to_cm(__u32 cycles);

#endif
