# A Tcl script for the Qsys system console

# Start Qsys, open your soc_system.qsys file, run File->System Console,
# then execute this script by selecting it with Ctrl-E

# The System Console is described in Chapter 10 of Volume III of
# the Quartus II Handbook

# Alternately,
# system-console --project_dir=. --script=syscon-test.tcl
#
# system-console --project_dir=. -cli
#   and then "source syscon-test.tcl"

# Base addresses of the peripherals: take from Qsys

set ultrasonic_0 0x0
set ultrasonic_1 0x4
set ultrasonic_2 0x8
set ultrasonic_3 0xc

set r_motor_dir 0x10
set r_motor_speed 0x14
set s_motor_dir 0x18
set s_motor_angle 0x1c

puts "Started system-console-test-script"


# Perform bus reads and writes

set m [lindex [get_service_paths master] 0]
open_service master $m
puts "Opened master"

# Write a test pattern to the various registers
#foreach {r v} {0 0xff 1 0x1 2 0x2 3 0x4 4 0x8 5 0x10 6 0x20 7 0x40} {
#    master_write_8 $m [expr $vga_led + $r] $v
#}



#regular_motor direction
master_write_32 $m $r_motor_dir 0x0

#regular_motor speed
master_write_32 $m $r_motor_speed 0x0

#steering_motor direction
master_write_32 $m $s_motor_dir 0x0

#steering_motor speed
master_write_32 $m $s_motor_angle 0x0

puts "Ultrasonic_0: [expr [master_read_32 $m $ultrasonic_0 1]*340*100/2/50000000] cm"
puts "Ultrasonic_1: [expr [master_read_32 $m $ultrasonic_1 1]*340*100/2/50000000] cm"
puts "Ultrasonic_2: [expr [master_read_32 $m $ultrasonic_2 1]*340*100/2/50000000] cm"
puts "Ultrasonic_3: [expr [master_read_32 $m $ultrasonic_3 1]*340*100/2/50000000] cm"

close_service master $m
puts "Closed master"




