module steering_motor_qsys(
			input logic				clk,
			input logic 	  		reset,
			//Please refer to regular motor one for the reason why I use 32bits instead of 8bits
			input logic [31:0]	writedata, // Only accept 8, 16, 32, 64,... bits;
			input logic 	  		write,
			input logic 			address,
			input logic   			chipselect,
			
			input logic 			stop, // emergency stop signal send from other peripheral (Ultrasonic)

			output logic 			motor_c1, motor_c2);


   //parameter  			
   //parameter		
	 
   //seperate direction and angle from writedata
   logic			direction;
	logic	[2:0]	angle;
	

	always_ff @ (posedge clk) begin
		if(reset) begin
			direction <= 0;
			angle <= 0;
		end else if (chipselect & write) begin
			if(address == 0) //set direction
				direction <= writedata[0];
			else //set angle				
				angle <= writedata[2:0]; //since the angle higher than MAX_ANGLE_LV will be deemed as MAX_ANGLE_LV, we don't check here. 
		end
	end
   steering_motor s_motor(.*);		
endmodule
