module steering_motor(
						input logic clk, reset,
						input logic [2:0] angle, // 0 is stop; angle level from 1 to 7
						input logic stop, //stop signal for emergency stop that will feed from ultrasonic sensors
						input logic direction, //right and left
						output logic motor_c1, motor_c2 //for motor pins 
					);	
	

	parameter 	MAX_ANGLE_LV = 7; //from 0 to 7. (should <= 7)
	
	enum logic {RIGHT,LEFT} dir, old_dir; 
	//enum logic [3:0] {STOP, SPEED1, SPEED2, SPEED3, SPEED4, SPEED5, SPEED6, SPEED7, SPEED8} spd;
	
	//convert input signals to what we use and do verifying
	assign dir = (direction == 1'b1) ? RIGHT : LEFT; 
	
	
	//we want reduce PWM clock freq from 50M to around 5k 
	logic [14:0] counter_10000;
	always_ff @ (posedge clk)
	begin
		if(reset) begin 
			counter_10000 <= 0; 
		end else begin
			if (counter_10000 < 10000)
				counter_10000 <= counter_10000 + 1'b1;
			else
				counter_10000 <= 1'b0;
		end
	end
	
	logic tick;
	assign tick = (counter_10000 == 10000)? 1'b1: 1'b0;
	
	logic [2:0] counter; //count pulse width
	always_ff @ (posedge clk)
	begin
		if(reset) begin 
			counter <= 0; 
		end else begin
			if(tick == 1'b1) begin
				if (counter < MAX_ANGLE_LV)
					counter <= counter + 1'b1;
				else
					counter <= 1'b0;
			end 
		end
	end
	
	//use to save old angle and dir so that when receive stop signal steering motor can
	//keep current angle no matter how input angle changes.
	logic [2:0] old_angle;
	always_ff @ (posedge clk) begin
		if(reset) begin 
			old_angle <= 0;
			old_dir <= RIGHT; 
		end else if(!stop) begin
			old_angle <= angle;
			old_dir <= dir;
		end
	end
	
	//motor control
	always_comb begin
		motor_c1 = 1'b0;
		motor_c2 = 1'b0;
		
		if(!stop) begin
			if(angle != 0) begin
				if(counter <= angle) begin
					if(dir == RIGHT) 
						motor_c1 = 1'b1;
					else
						motor_c2 = 1'b1;
				end
			end
		end else begin
			if(old_angle != 0) begin
				if(counter <= old_angle) begin
					if(old_dir == RIGHT) 
						motor_c1 = 1'b1;
					else
						motor_c2 = 1'b1;
				end
			end
		end
	end
endmodule

