module regular_motor_qsys(
			input logic				clk,
			input logic 	  		reset,
			//Note: we use 32 bits instead of 8bits because ARM is 32bits,
			//and if we use e.g. 16bits, avalon bus will actually send us 
			//singal twice. 16 bits each, but one with byteenable=11 and
			//another with byteenable = 00. Therefore we will need to receive
			//and handle byteenable signal, or it may execute twice. More over,
			//it may not be as simple as we might though. When I tried to use
			//8bits writedata and 0x10 of base, I found that when I test it with
			//.tcl in System Console, all master_write_8 to 0x10, 0x11, 0x12 and 
		   //0x13 will result in controlling this regular motor, which should 
			//only occupy 0x10. Furthermore, the steering motor which I set to 
			//also 8bits and base at 0x11 can't be controlled in this case, no matter
			//which address I write to using master_write_8.
			//That means, not only this peripheral, all peripherals
		   //near this one may also need to handle byteenable signal!
			input logic [31:0]	writedata, // Only accept 8, 16, 32, 64,... bits;
			input logic 	  		write,
			input logic 			address,
			input logic   			chipselect,
			
			input logic 			stop, // emergency stop signal send from other peripheral (Ultrasonic)

			output logic 			motor_c1, motor_c2, motor_en);


   //parameter  			
   //parameter		
	 
   //seperate direction and speed from writedata
   logic			direction;
	logic	[3:0]	speed;
	

	always_ff @ (posedge clk) begin
		if(reset) begin
			direction <= 0;
			speed <= 0;
		end else if (chipselect & write) begin
			if(address == 0) //set direction
				direction <= writedata[0];
			else //set speed			
				speed <= writedata[3:0]; //since the speed higher than MAX_SPEED_LV will be deemed as MAX_SPEED_LV, we don't check here. 
		end

	end
   regular_motor r_motor(.*);		
endmodule
